/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.ReviewUtil;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.ui.skynet.internal.Activator;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlabelMemberSelectionDam;

public class XHyperlinkMeetingAttendeesSelectionDam
extends XHyperlabelMemberSelectionDam {
    public XHyperlinkMeetingAttendeesSelectionDam() {
        super(ReviewUtil.MEETING_ATTENDEES_LABEL);
    }

    public Set<User> getStoredUsers() {
        HashSet<User> users = new HashSet<User>();
        try {
            for (Object artIdObj : this.artifact.getAttributeValues((AttributeTypeId)AtsAttributeTypes.MeetingAttendeeId)) {
                try {
                    users.add(UserManager.getUserByArtId((ArtifactId)((ArtifactId)artIdObj)));
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
            boolean meetingAttendeeAsUserId = AtsApiService.get().isConfigValue("MeetingAttendeeAsUserId", false);
            if (meetingAttendeeAsUserId) {
                for (Object artUserIdObj : this.artifact.getAttributeValues((AttributeTypeId)AtsAttributeTypes.MeetingAttendeeUserId)) {
                    try {
                        if (!Strings.isValid((String)((String)artUserIdObj))) continue;
                        users.add(UserManager.getUserByUserId((String)((String)artUserIdObj)));
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return users;
    }

    public void saveToArtifact() {
        try {
            this.artifact.setAttributeFromValues((AttributeTypeId)AtsAttributeTypes.MeetingAttendeeId, (Collection)this.getSelectedUsers());
            boolean meetingAttendeeAsUserId = AtsApiService.get().isConfigValue("MeetingAttendeeAsUserId", false);
            if (meetingAttendeeAsUserId) {
                HashSet<String> userIds = new HashSet<String>();
                for (ArtifactId id : this.getSelectedUsers()) {
                    AtsUser user = AtsApiService.get().getUserService().getUserById(id);
                    userIds.add(user.getUserId());
                }
                this.artifact.setAttributeFromValues((AttributeTypeId)AtsAttributeTypes.MeetingAttendeeUserId, userIds);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }
}

