/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.column.PointsColumnUI;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelCmdValueSelDam;

public class XEstimatedPointsWidget
extends XHyperlinkLabelCmdValueSelDam
implements ArtifactWidget {
    public float points = 0.0f;
    private final AtsApi atsApi = AtsApiService.get();
    private IAtsWorkItem workItem;
    private AttributeTypeToken pointsAttrType = null;

    public XEstimatedPointsWidget() {
        super("Estimated Points", true, Integer.valueOf(50));
    }

    public String getCurrentValue() {
        AttributeTypeToken pointsAttrType = this.getAttributeType();
        if (pointsAttrType.isInvalid()) {
            pointsAttrType = AtsAttributeTypes.PointsNumeric;
        }
        return this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)this.workItem, pointsAttrType, "");
    }

    public boolean handleSelection() {
        return PointsColumnUI.promptChangePoints(this.workItem, this.getPointsAttrType(), this.atsApi);
    }

    public boolean handleClear() {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Remove Points");
        changes.deleteAttributes((IAtsObject)this.workItem, this.getPointsAttrType());
        changes.executeIfNeeded();
        this.refresh();
        return true;
    }

    private AttributeTypeToken getPointsAttrType() {
        if (this.pointsAttrType == null) {
            this.pointsAttrType = this.atsApi.getAgileService().getPointsAttrType(this.workItem);
        }
        return this.pointsAttrType;
    }

    public Artifact getArtifact() {
        return (Artifact)this.workItem.getStoreObject();
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setArtifact(Artifact artifact) {
        if (artifact instanceof IAtsWorkItem) {
            this.workItem = (IAtsWorkItem)artifact;
        }
    }
}

