/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XArtifactReferencedAttributeWidget;

public class XArtifactReferencedAtsObjectAttributeWidget
extends XArtifactReferencedAttributeWidget {
    public static final String SENTINEL = "-1";

    public XArtifactReferencedAtsObjectAttributeWidget(String displayLabel) {
        super(displayLabel);
    }

    public XArtifactReferencedAtsObjectAttributeWidget(String displayLabel, ArtifactTypeToken validArtifactType) {
        super(displayLabel, validArtifactType);
    }

    protected String getDisplayValue(String value) {
        String displayValue = value;
        String errorMsg = "";
        if (Strings.isNumeric((String)value)) {
            boolean isWorkDef = false;
            if (this.getAttributeType().equals(AtsAttributeTypes.WorkflowDefinitionReference) || this.getAttributeType().equals(AtsAttributeTypes.RelatedPeerWorkflowDefinitionReference) || this.getAttributeType().equals(AtsAttributeTypes.RelatedTaskWorkflowDefinitionReference)) {
                if (value.equals(SENTINEL)) {
                    return "";
                }
                WorkDefinition workDef = AtsApiService.get().getWorkDefinitionService().getWorkDefinition(Long.valueOf(value));
                isWorkDef = true;
                if (workDef != null && workDef.isValid()) {
                    displayValue = workDef.toStringWithId();
                } else {
                    errorMsg = String.format("Error: Can't retrieve work def with id %s", value);
                }
            }
            if (!isWorkDef) {
                try {
                    ArtifactToken artifactToken = AtsApiService.get().getQueryService().getArtifactTokenOrSentinal(ArtifactId.valueOf((String)value));
                    if (artifactToken.isValid()) {
                        displayValue = artifactToken.toStringWithId();
                    } else {
                        errorMsg = String.format("Error: No artifact found with id %s", value);
                    }
                }
                catch (Exception ex) {
                    errorMsg = String.format("Error: Exception retrieving artifact with id %s (see Error Log for details)", value);
                    OseeLog.log(XArtifactReferencedAtsObjectAttributeWidget.class, (Level)Level.SEVERE, (String)errorMsg, (Throwable)ex);
                }
            }
        }
        if (Strings.isValid((String)errorMsg)) {
            this.setMessage(4, errorMsg);
        }
        return displayValue;
    }
}

