/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.internal;

import java.util.Collection;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.users.AbstractAtsUserService;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;

public class AtsUserServiceClientImpl
extends AbstractAtsUserService {
    Boolean atsAdmin = null;
    Boolean atsDeleteWorkflowAdmin = null;
    private AtsUser currentUser;

    public void setCurrentUser(AtsUser currentUser) {
        this.currentUser = currentUser;
    }

    public void clearCaches() {
        this.currentUser = null;
        this.atsAdmin = null;
    }

    public AtsUser getCurrentUser() {
        if (this.currentUser == null) {
            User user = UserManager.getUser();
            this.currentUser = new AtsUser();
            this.currentUser.setName(user.getName());
            this.currentUser.setUserId(user.getUserId());
            this.currentUser.setEmail(user.getEmail());
            this.currentUser.setActive(user.isActive());
            this.currentUser.setId(user.getId());
            this.currentUser.getLoginIds().addAll(user.getLoginIds());
            this.currentUser.setPhone(user.getPhone());
            this.currentUser.setStoreObject((ArtifactToken)user);
        }
        return this.currentUser;
    }

    public AtsUser getCurrentUserNoCache() {
        this.clearCaches();
        return this.getCurrentUser();
    }

    public AtsUser getUserById(ArtifactId userId) {
        return (AtsUser)this.configurationService.getConfigurations().getIdToUser().get(userId.getId());
    }

    public String getCurrentUserId() {
        return UserManager.getUser().getUserId();
    }

    public AtsUser getCurrentUserOrNull() {
        User user = UserManager.getUser();
        if (user.isValid()) {
            return this.getUserById((ArtifactId)user);
        }
        return null;
    }

    public boolean isAtsAdmin() {
        if (this.atsAdmin == null) {
            this.atsAdmin = AtsApiService.get().userService().isInUserGroup(new IUserGroupArtifactToken[]{AtsUserGroups.AtsAdmin});
        }
        return this.atsAdmin;
    }

    public boolean isAtsDeleteWorkflowAdmin() {
        if (this.atsDeleteWorkflowAdmin == null) {
            this.atsDeleteWorkflowAdmin = AtsApiService.get().userService().isUserMember(AtsUserGroups.AtsDeleteWorkflowAdmin, (ArtifactId)AtsApiService.get().getUserService().getCurrentUser());
        }
        return this.atsDeleteWorkflowAdmin;
    }

    public Collection<AtsUser> getUsers() {
        return this.configurationService.getConfigurations().getUsers();
    }
}

