/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.util.AbstractAtsChangeSet;
import org.eclipse.osee.ats.core.util.AtsRelationChange;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class AtsChangeSet
extends AbstractAtsChangeSet {
    private SkynetTransaction transaction;

    public AtsChangeSet(String comment) {
        this(comment, AtsApiService.get().getAtsBranch(), AtsApiService.get().getUserService().getCurrentUser());
    }

    public AtsChangeSet(String comment, AtsUser asUser) {
        this(comment, AtsApiService.get().getAtsBranch(), asUser);
    }

    public AtsChangeSet(String comment, BranchToken branch, AtsUser asUser) {
        super(comment, branch, asUser);
    }

    private Artifact getArtifact(Object obj) {
        Artifact art = null;
        if (obj instanceof Artifact) {
            art = AtsApiService.get().getQueryServiceIde().getArtifact(obj);
        } else if (obj instanceof IAtsObject) {
            IAtsObject atsObject = (IAtsObject)obj;
            ArtifactToken storeObject = atsObject.getStoreObject();
            if (storeObject != null) {
                art = this.getArtifact(storeObject);
            }
            if (art == null) {
                art = (Artifact)AtsApiService.get().getQueryService().getArtifact(atsObject.getId());
            }
        } else if (obj instanceof ArtifactId) {
            art = (Artifact)AtsApiService.get().getQueryService().getArtifact(((ArtifactId)obj).getId());
        }
        if (art == null && obj instanceof Id) {
            IAtsObject atsObject;
            ArtifactId storedArt = this.getStoredArtifact((Id)obj);
            if (storedArt != null && storedArt instanceof Artifact) {
                art = (Artifact)storedArt;
            }
            if (art == null && (atsObject = this.getStoredAtsObject((Id)obj)) != null && atsObject.getStoreObject() instanceof Artifact) {
                art = (Artifact)atsObject.getStoreObject();
            }
        }
        return art;
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeToken attributeType) {
        this.checkExecuted();
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(workItem);
        artifact.deleteSoleAttribute((AttributeTypeId)attributeType);
        this.add(artifact);
    }

    public void setSoleAttributeValue(IAtsWorkItem workItem, AttributeTypeToken attributeType, String value) {
        this.checkExecuted();
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(workItem);
        artifact.setSoleAttributeValue((AttributeTypeId)attributeType, (Object)value);
        this.add(artifact);
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeToken attributeType, Object value) {
        this.checkExecuted();
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(atsObject);
        artifact.setSoleAttributeValue((AttributeTypeId)attributeType, value);
        this.add(artifact);
    }

    public void addAttribute(IAtsObject atsObject, AttributeTypeToken attributeType, Object value) {
        this.checkExecuted();
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(atsObject);
        artifact.addAttribute((AttributeTypeId)attributeType, value);
        this.add(artifact);
    }

    public void deleteAttribute(IAtsObject atsObject, AttributeTypeToken attributeType, Object value) {
        this.checkExecuted();
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(atsObject);
        artifact.deleteAttribute((AttributeTypeId)attributeType, value);
        this.add(artifact);
    }

    public void deleteAttribute(ArtifactToken artifact, AttributeTypeToken attributeType, Object value) {
        this.checkExecuted();
        Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)artifact);
        art.deleteAttribute((AttributeTypeId)attributeType, value);
        this.add(art);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<T> attr, AttributeTypeId attributeType, T value) {
        this.checkExecuted();
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(workItem);
        Attribute attribute = (Attribute)attr;
        attribute.setValue(value);
        this.add(artifact);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr) {
        this.checkExecuted();
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(workItem);
        Attribute attribute = (Attribute)attr;
        attribute.delete();
        this.add(artifact);
    }

    public boolean isAttributeTypeValid(IAtsWorkItem workItem, AttributeTypeId attributeType) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(workItem);
        return artifact.getAttributeTypes().contains(attributeType);
    }

    public void deleteAttributes(IAtsObject atsObject, AttributeTypeToken attributeType) {
        this.checkExecuted();
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(atsObject);
        artifact.deleteAttributes((AttributeTypeId)attributeType);
        this.add(artifact);
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name, Long artifactId) {
        this.checkExecuted();
        Artifact artifact = ArtifactTypeManager.addArtifact((ArtifactTypeToken)artifactType, (BranchToken)this.atsApi.getAtsBranch(), (String)name, (Long)artifactId);
        this.add(artifact);
        return artifact;
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name) {
        this.checkExecuted();
        Artifact artifact = ArtifactTypeManager.addArtifact((ArtifactTypeToken)artifactType, (BranchToken)this.atsApi.getAtsBranch(), (String)name);
        this.add(artifact);
        return artifact;
    }

    public void relate(Object object1, RelationTypeSide relationSide, Object object2) {
        this.checkExecuted();
        this.relatePrivate(object1, relationSide, object2);
    }

    public void relate(ArtifactId artifact1, RelationTypeSide relationSide, ArtifactId artifact2) {
        this.checkExecuted();
        this.relatePrivate(artifact1, relationSide, artifact2);
    }

    public void relatePrivate(Object object1, RelationTypeSide relationSide, Object object2) {
        this.checkExecuted();
        Artifact artifact = this.getArtifact(object1);
        Artifact artifact2 = this.getArtifact(object2);
        artifact.addRelation(relationSide, artifact2);
        this.add(artifact);
        this.add(artifact2);
    }

    public void unrelateAll(Object object, RelationTypeSide relationType) {
        this.checkExecuted();
        Artifact artifact = this.getArtifact(object);
        artifact.deleteRelations(relationType);
        this.add(artifact);
    }

    public void setRelations(Object object, RelationTypeSide relationSide, Collection<? extends Object> objects) {
        this.checkExecuted();
        Artifact artifact = this.getArtifact(object);
        HashSet<Artifact> artifacts = new HashSet<Artifact>(objects.size());
        for (Object object2 : objects) {
            Artifact art = this.getArtifact(object2);
            if (art == null) continue;
            artifacts.add(art);
            this.add(art);
        }
        artifact.setRelations(relationSide, artifacts);
        this.add(artifact);
    }

    public void setRelationsAndOrder(Object object, RelationTypeSide relationSide, Collection<? extends Object> objects) {
        this.checkExecuted();
        Artifact artifact = this.getArtifact(object);
        HashSet<Artifact> artifacts = new HashSet<Artifact>(objects.size());
        for (Object object2 : objects) {
            Artifact art = this.getArtifact(object2);
            if (art == null) continue;
            artifacts.add(art);
            this.add(art);
        }
        artifact.setRelations(RelationSorter.USER_DEFINED, relationSide, artifacts);
        this.add(artifact);
    }

    public <T> void setAttribute(IAtsWorkItem workItem, AttributeId attributeId, T value) {
        this.checkExecuted();
        Conditions.checkExpressionFailOnTrue((boolean)attributeId.isInvalid(), (String)"Can not set attribute by id that has not be persisted.  Attribute Id [%s] Work Item [%s]", (Object[])new Object[]{attributeId, workItem.toStringWithId()});
        Artifact artifact = this.getArtifact(workItem);
        Conditions.checkNotNull((Object)artifact, (String)"artifact");
        boolean found = false;
        for (Attribute attribute : artifact.getAttributes()) {
            if (!attributeId.equals(attribute)) continue;
            attribute.setValue(value);
            found = true;
            break;
        }
        if (!found) {
            throw new OseeStateException("Attribute Id %s does not exist on Artifact %s", new Object[]{attributeId, workItem});
        }
        this.add(artifact);
    }

    public void deleteArtifact(ArtifactId artifact) {
        this.checkExecuted();
        Artifact art = this.getArtifact(artifact);
        art.delete();
        this.add(art);
    }

    public void setAttributeValues(IAtsObject atsObject, AttributeTypeToken attrType, List<Object> values) {
        this.checkExecuted();
        Artifact artifact = this.getArtifact(atsObject);
        artifact.setAttributeFromValues((AttributeTypeId)attrType, values);
        this.add(artifact);
    }

    public void setAttributeValues(ArtifactId artifact, AttributeTypeToken attrType, List<Object> values) {
        this.checkExecuted();
        AtsApiService.get().getQueryServiceIde().getArtifact(artifact).setAttributeFromValues((AttributeTypeId)attrType, values);
        this.add(artifact);
    }

    public <T> void setAttribute(ArtifactId artifact, AttributeId attrId, T value) {
        this.checkExecuted();
        Conditions.checkExpressionFailOnTrue((boolean)attrId.isInvalid(), (String)"Can not set attribute by id that has not been persisted.  Attribute Id [%s] ArtifactId [%s]", (Object[])new Object[]{attrId, artifact.toString()});
        boolean found = false;
        for (Attribute attribute : this.getArtifact(artifact).getAttributes()) {
            if (!attrId.equals(attribute)) continue;
            attribute.setFromString(String.valueOf(value));
            found = true;
            break;
        }
        if (!found) {
            throw new OseeStateException("Attribute Id %s does not exist on Artifact %s", new Object[]{attrId, artifact});
        }
        this.add(artifact);
    }

    public void deleteAttribute(ArtifactId userArt, IAttribute<?> attr) {
        this.checkExecuted();
        Artifact artifact = this.getArtifact(userArt);
        artifact.deleteAttribute(attr);
        this.add(artifact);
    }

    public void setSoleAttributeValue(ArtifactId artifact, AttributeTypeToken attrType, Object value) {
        this.checkExecuted();
        Artifact art = this.getArtifact(artifact);
        art.setSoleAttributeValue((AttributeTypeId)attrType, value);
        this.add(artifact);
    }

    public void unrelate(ArtifactId artifact, RelationTypeSide relationSide, ArtifactId artifact2) {
        this.checkExecuted();
        Artifact art = this.getArtifact(artifact);
        Artifact art2 = this.getArtifact(artifact2);
        art.deleteRelation(relationSide, art2);
        this.add(art);
        this.add(art2);
    }

    public void addAttribute(ArtifactId artifact, AttributeTypeToken attrType, Object value) {
        this.checkExecuted();
        Artifact art = this.getArtifact(artifact);
        art.addAttribute((AttributeTypeId)attrType, value);
        this.add(art);
    }

    public void setSoleAttributeFromString(ArtifactId artifact, AttributeTypeGeneric<?> attributeType, String value) {
        this.checkExecuted();
        Artifact art = this.getArtifact(artifact);
        art.setSoleAttributeFromString(attributeType, value);
        this.add(art);
    }

    public void setSoleAttributeFromStream(ArtifactId artifact, AttributeTypeGeneric<?> attributeType, InputStream inputStream) {
        this.checkExecuted();
        Artifact art = this.getArtifact(artifact);
        art.setSoleAttributeFromStream(attributeType, inputStream);
        this.add(art);
    }

    public void unrelateFromAll(RelationTypeSide relationSide, ArtifactId artifact) {
        this.checkExecuted();
        Artifact art = this.getArtifact(artifact);
        art.deleteRelations(relationSide);
    }

    public void addArtifactReferencedAttribute(ArtifactId artifact, AttributeTypeToken attributeType, ArtifactId artifactRef) {
        this.checkExecuted();
        Artifact art = this.getArtifact(artifact);
        art.addAttributeFromString((AttributeTypeId)attributeType, artifactRef.getIdString());
    }

    public void deleteAttributes(ArtifactId artifact, AttributeTypeToken attributeType) {
        this.checkExecuted();
        Artifact art = this.getArtifact(artifact);
        art.deleteAttributes((AttributeTypeId)attributeType);
        this.add(art);
    }

    public void setAttributeValuesAsStrings(IAtsObject atsObject, AttributeTypeToken attributeType, List<String> values) {
        this.checkExecuted();
        LinkedList<Object> objValues = new LinkedList<Object>();
        for (String value : values) {
            if (attributeType.isString() || attributeType.isEnumerated()) {
                try {
                    objValues.add(value);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid date value [%s]; must be long date", new Object[]{value});
                }
            }
            if (attributeType.isDate()) {
                try {
                    Date date = new Date(Long.valueOf(value));
                    objValues.add(date);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid date value [%s]; must be long date", new Object[]{value});
                }
            }
            if (attributeType.isDouble()) {
                try {
                    Double double1 = Double.valueOf(value);
                    objValues.add(double1);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid double value [%s]", new Object[]{value});
                }
            }
            if (attributeType.isInteger()) {
                try {
                    Integer integer = Integer.valueOf(value);
                    objValues.add(integer);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid integer value [%s]", new Object[]{value});
                }
            }
            if (attributeType.isLong()) {
                try {
                    Long longVal = Long.valueOf(value);
                    objValues.add(longVal);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid long value [%s]", new Object[]{value});
                }
            }
            if (attributeType.isBoolean()) {
                try {
                    Boolean bool = Boolean.valueOf(value);
                    objValues.add(bool);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid boolean value [%s]", new Object[]{value});
                }
            }
            throw new OseeArgumentException("Unsupported attribute value [%s] for type [%s]", new Object[]{attributeType, value});
        }
        this.setAttributeValues(atsObject, attributeType, objValues);
    }

    public ArtifactToken createArtifact(ArtifactToken parent, ArtifactTypeToken artType, String name) {
        this.checkExecuted();
        Artifact artifact = ArtifactTypeManager.addArtifact((ArtifactTypeToken)artType, (BranchToken)this.atsApi.getAtsBranch(), (String)name);
        this.addChild((ArtifactId)parent, (ArtifactId)artifact);
        this.add(artifact);
        return artifact;
    }

    public void deleteRelation(RelationId relId) {
        this.checkExecuted();
        if (relId instanceof RelationLink) {
            RelationLink relation = (RelationLink)relId;
            SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)CoreBranches.COMMON, (String)"Delete Relation");
            relation.delete(false, transaction);
            transaction.addArtifact(relation.getArtifactA());
            transaction.execute();
        }
    }

    public void addTag(ArtifactToken artifact, String tag) {
        this.checkExecuted();
        if (!((Artifact)artifact).getTags().contains(tag)) {
            this.addAttribute((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)tag);
        }
    }

    protected void internalExecuteTransaction() {
        this.transaction = TransactionManager.createTransaction((BranchId)this.branch, (String)this.comment);
        for (IAtsObject atsObject : new ArrayList(this.atsObjects)) {
            this.transaction.addArtifact(AtsApiService.get().getQueryServiceIde().getArtifact(atsObject));
        }
        for (ArtifactId artifact : this.artifacts) {
            if (!(artifact instanceof Artifact)) continue;
            this.transaction.addArtifact(AtsApiService.get().getQueryServiceIde().getArtifact(artifact));
        }
        for (AtsRelationChange rel : this.relations) {
            this.executeRelChange(rel, this.transaction);
        }
        for (ArtifactId artifact : this.deleteArtifacts) {
            if (!(artifact instanceof Artifact) || this.atsApi.getStoreService().isDeleted(artifact)) continue;
            AtsApiService.get().getQueryServiceIde().getArtifact(artifact).deleteAndPersist(this.transaction);
        }
        for (IAtsObject atsObject : this.deleteAtsObjects) {
            if (AtsApiService.get().getStoreService().isDeleted((ArtifactId)atsObject.getStoreObject())) continue;
            AtsApiService.get().getQueryServiceIde().getArtifact(atsObject).deleteAndPersist(this.transaction);
        }
        TransactionToken transTok = this.transaction.execute();
        if (transTok != null) {
            this.transactionTok = transTok;
        }
    }

    protected void executeHandleException(Exception ex) {
        this.transaction.cancel();
        super.executeHandleException(ex);
    }

    private void executeRelChange(AtsRelationChange relChange, SkynetTransaction transaction) {
        Conditions.checkNotNull((Object)relChange, (String)"relChange");
        Conditions.checkNotNull((Object)relChange.getRelationSide(), (String)"relationSide");
        Object obj = relChange.getObject();
        Artifact art = this.getArtifact(obj);
        Conditions.checkNotNull((Object)art, (String)"artifact");
        Collection objects = relChange.getObjects();
        Conditions.checkNotNullOrEmpty((Collection)objects, (String)"objects");
        HashSet<Artifact> arts = new HashSet<Artifact>();
        for (Object obj2 : objects) {
            Artifact art2 = this.getArtifact(obj2);
            Conditions.checkNotNull((Object)art2, (String)"toArtifact");
            arts.add(art2);
        }
        for (Artifact artifact : arts) {
            List relatedArtifacts = art.getRelatedArtifacts(relChange.getRelationSide());
            if (relChange.getOperation() == AtsRelationChange.RelationOperation.Add && !relatedArtifacts.contains(artifact)) {
                art.addRelation(relChange.getRelationSide(), artifact);
                continue;
            }
            if (relChange.getOperation() != AtsRelationChange.RelationOperation.Delete || !relatedArtifacts.contains(artifact)) continue;
            art.deleteRelation(relChange.getRelationSide(), artifact);
        }
        art.persist(transaction);
    }
}

