/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.Import;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.RelatedToStateColumnUI;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ImportTasksFromSimpleList
extends AbstractBlam {
    public static final String ASSIGNEES = "Assignees";
    public static final String TEAM_WORKFLOW = "Team Workflow (drop here)";
    protected IAtsTeamWorkflow teamWf;
    protected AtsWorkDefinitionToken taskWorkDef = AtsWorkDefinitionToken.SENTINEL;
    private XCombo stateCombo;

    public String getName() {
        return "Import Tasks From Simple List";
    }

    protected String getTitlesLabel() {
        return "Task Import Titles";
    }

    public void runOperation(final VariableMap variableMap, IProgressMonitor monitor) {
        final AtsApiIde atsApi = AtsApiService.get();
        final String commitComment = ((Object)((Object)this)).getClass().getSimpleName();
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                block15: {
                    artifacts = new HashSet<Artifact>();
                    artifacts.addAll(variableMap.getArtifacts("Team Workflow (drop here)"));
                    if (ImportTasksFromSimpleList.this.teamWf != null) {
                        artifacts.add((Artifact)ImportTasksFromSimpleList.this.teamWf);
                    }
                    assignees = new ArrayList<AtsUser>();
                    for (Artifact art : variableMap.getArtifacts("Assignees")) {
                        if (!(art instanceof User)) continue;
                        atsUser = atsApi.getUserService().getUserById((ArtifactId)art);
                        assignees.add(atsUser);
                    }
                    titles = new ArrayList<String>();
                    var7_10 = variableMap.getString(ImportTasksFromSimpleList.this.getTitlesLabel()).split("\n");
                    var6_11 = var7_10.length;
                    atsUser = 0;
                    while (atsUser < var6_11) {
                        title = var7_10[atsUser];
                        if (!(title = title.replaceAll("\r", "")).equals("")) {
                            titles.add(title);
                        }
                        ++atsUser;
                    }
                    if (artifacts.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"Must drag in Team Workflow to add tasks.");
                        return;
                    }
                    if (artifacts.size() > 1) {
                        AWorkbench.popup((String)"ERROR", (String)"Only drag ONE Team Workflow.");
                        return;
                    }
                    artifact = (Artifact)artifacts.iterator().next();
                    if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                        AWorkbench.popup((String)"ERROR", (String)"Artifact MUST be Team Workflow");
                        return;
                    }
                    if (!titles.isEmpty()) break block15;
                    AWorkbench.popup((String)"ERROR", (String)"Must enter title(s).");
                    return;
                }
                try {
                    if (assignees.isEmpty()) {
                        assignees.add(AtsCoreUsers.UNASSIGNED_USER);
                    }
                    teamWf = atsApi.getWorkItemService().getTeamWf((ArtifactToken)artifact);
                    newTaskData = NewTaskData.create((IAtsTeamWorkflow)teamWf, titles, assignees, null, (AtsUser)atsApi.getUserService().getCurrentUser(), null, null, null);
                    if (ImportTasksFromSimpleList.this.taskWorkDef.isValid()) {
                        newTaskData.setTaskWorkDef(ImportTasksFromSimpleList.this.taskWorkDef);
                    }
                    if ((createTasks = atsApi.getTaskService().createTasks(NewTaskSet.create((NewTaskData)newTaskData, (String)commitComment, (String)atsApi.getUserService().getCurrentUserId()))).isErrors()) {
                        XResultDataUI.report((XResultData)createTasks.getResults(), (String)ImportTasksFromSimpleList.this.getName());
                        return;
                    }
                    ** GOTO lbl57
                }
                catch (Exception ex) {
                    try {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        return;
lbl57:
                        // 1 sources

                        artifact.reloadAttributesAndRelations();
                        WorkflowEditor.editArtifact(artifact);
                        return;
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            }
        });
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals(TEAM_WORKFLOW) && this.teamWf != null) {
            final XListDropViewer viewer = (XListDropViewer)xWidget;
            viewer.setInput(Arrays.asList(this.teamWf));
            xWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    List artifacts = viewer.getArtifacts();
                    ImportTasksFromSimpleList.this.teamWf = artifacts.isEmpty() || !(artifacts.iterator().next() instanceof IAtsTeamWorkflow) ? null : (IAtsTeamWorkflow)artifacts.iterator().next();
                    try {
                        ImportTasksFromSimpleList.this.refreshStateCombo();
                    }
                    catch (OseeStateException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            });
        } else if (xWidget.getLabel().equals(RelatedToStateColumnUI.RELATED_TO_STATE_SELECTION)) {
            this.stateCombo = (XCombo)xWidget;
            this.refreshStateCombo();
        }
    }

    private void refreshStateCombo() {
        if (this.stateCombo != null && this.teamWf != null) {
            List<String> names = RelatedToStateColumnUI.getValidInWorkStates((TeamWorkFlowArtifact)this.teamWf);
            this.stateCombo.setDataStrings(names.toArray(new String[names.size()]));
        }
    }

    public String getXWidgetsXml() {
        StringBuffer buffer = new StringBuffer("<xWidgets>");
        this.createTeamWfWidget(buffer);
        buffer.append("<XWidget xwidgetType=\"XText\" fill=\"Vertically\" height=\"80\" displayName=\"" + this.getTitlesLabel() + "\" toolTip=\"Enter task titles one per line\"/>");
        buffer.append("<XWidget xwidgetType=\"XCombo()\" beginComposite=\"2\" labelAfter=\"true\" height=\"80\" displayName=\"" + RelatedToStateColumnUI.RELATED_TO_STATE_SELECTION + "\" />");
        buffer.append("<XWidget xwidgetType=\"XHyperlabelMemberSelection\" displayName=\"Assignees\" />");
        buffer.append("</xWidgets>");
        return buffer.toString();
    }

    protected void createTeamWfWidget(StringBuffer buffer) {
        buffer.append("<XWidget xwidgetType=\"XListDropViewer\" displayName=\"Team Workflow (drop here)\" />");
    }

    public String getDescriptionUsage() {
        return "Import tasks from spreadsheet into given Team Workflow.  Assignee for tasks will be current user unless otherwise specified.";
    }

    public void setTeamWf(IAtsTeamWorkflow teamWf) {
        this.teamWf = teamWf;
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AtsNavigateViewItems.ATS_IMPORT);
    }

    public void setTaskWorkDef(AtsWorkDefinitionToken taskWorkDef) {
        this.taskWorkDef = taskWorkDef;
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)FrameworkImage.IMPORT);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.IMPORT);
    }
}

