/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.core.query.AbstractAtsQueryImpl;
import org.eclipse.osee.ats.core.query.AtsAttributeQuery;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;

public class AtsQueryImpl
extends AbstractAtsQueryImpl {
    private QueryBuilderArtifact query;

    public AtsQueryImpl(AtsApi atsApi) {
        super(atsApi);
    }

    public Collection<? extends ArtifactToken> runQuery() {
        return this.query.getResults().getList();
    }

    public Collection<? extends ArtifactToken> runQueryNew() {
        throw new UnsupportedOperationException();
    }

    public void createQueryBuilder() {
        if (this.query == null) {
            this.query = ArtifactQuery.createQueryBuilder((BranchId)AtsApiService.get().getAtsBranch());
        }
    }

    public void queryAnd(AttributeTypeToken attrType, Collection<String> values) {
        this.query.and((AttributeTypeId)attrType, values, new QueryOption[0]);
    }

    public void queryAndIsOfType(ArtifactTypeToken artifactType) {
        this.query.andIsOfType(new ArtifactTypeId[]{artifactType});
    }

    public List<ArtifactId> queryGetIds() {
        return this.query.getIds();
    }

    public void queryAndIsOfType(Collection<ArtifactTypeToken> artTypes) {
        this.query.andIsOfType(artTypes);
    }

    public void queryAnd(AttributeTypeToken attrType, String value) {
        this.query.and((AttributeTypeId)attrType, value, new QueryOption[0]);
    }

    public void queryAndRelatedToLocalIds(RelationTypeSide relationTypeSide, ArtifactId artId) {
        this.query.andRelatedTo(relationTypeSide, new ArtifactId[]{artId});
    }

    public void queryAndRelatedTo(RelationTypeSide relationTypeSide, List<ArtifactId> artIds) {
        this.query.andRelatedTo(relationTypeSide, artIds);
    }

    public void queryAnd(AttributeTypeToken attrType, Collection<String> values, QueryOption[] queryOption) {
        this.query.and((AttributeTypeId)attrType, values, queryOption);
    }

    public void queryAnd(AttributeTypeToken attrType, String value, QueryOption[] queryOption) {
        this.query.and((AttributeTypeId)attrType, value, queryOption);
    }

    public void queryAndIds(Collection<? extends ArtifactId> artIds) {
        this.query.andIds(artIds);
    }

    public void queryAndNotExists(RelationTypeSide relationTypeSide) {
        this.query.andNotExists(relationTypeSide);
    }

    public void queryAndExists(RelationTypeSide relationTypeSide) {
        this.query.andExists(relationTypeSide);
    }

    public List<ArtifactId> getRelatedTeamWorkflowIdsBasedOnTeamDefsAisAndVersions(List<AtsAttributeQuery> teamWorkflowAttr) {
        AtsQueryImpl search = new AtsQueryImpl(this.atsApi);
        search.isOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow});
        if (this.teamDefIds != null && !this.teamDefIds.isEmpty()) {
            search.andTeam(new ArrayList(this.teamDefIds));
        }
        if (teamWorkflowAttr != null && !teamWorkflowAttr.isEmpty()) {
            for (AtsAttributeQuery attrQuery : teamWorkflowAttr) {
                search.andAttr.add(attrQuery);
            }
        }
        if (this.aiIds != null && !this.aiIds.isEmpty()) {
            search.andActionableItem(new ArrayList(this.aiIds));
        }
        if (this.versionId != null && this.versionId > 0L) {
            search.andVersion(this.versionId);
        }
        return new ArrayList<ArtifactId>(search.getItemIds());
    }

    protected void queryAndNotExists(AttributeTypeToken attributeType) {
        this.query.andNotExists((AttributeTypeId)attributeType);
    }

    protected void queryAndExists(AttributeTypeToken attributeType) {
        this.query.andExists(new AttributeTypeId[]{attributeType});
    }
}

