/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.query.AtsSearchDataResults;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.query.ISearchCriteriaProvider;
import org.eclipse.osee.ats.core.query.AtsSearchDataSearch;
import org.eclipse.osee.ats.core.query.AtsSearchDataVersionSearch;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;

public class WorldSearchItem
extends WorldUISearchItem
implements ISearchCriteriaProvider {
    AtsSearchData data;

    public WorldSearchItem(AtsSearchData data) {
        super(data.getSearchName());
        this.data = data.copy();
    }

    public WorldSearchItem(String searchName) {
        super(searchName);
        this.data = new AtsSearchData(searchName);
    }

    @Override
    public String getSelectedName(WorldSearchItem.SearchType searchType) {
        return super.getSelectedName(searchType);
    }

    @Override
    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        if (this.data.getVersionId() != null && this.data.getVersionId() > 0L) {
            AtsSearchDataVersionSearch query = new AtsSearchDataVersionSearch(this.data, (AtsApi)AtsApiService.get());
            AtsSearchDataResults results = query.performSearch();
            if (results.getRd().isErrors()) {
                XResultDataUI.report((XResultData)results.getRd(), (String)this.getName());
            }
            return Collections.castAll((Collection)results.getArtifacts());
        }
        AtsSearchDataSearch query = new AtsSearchDataSearch(this.data, (AtsApi)AtsApiService.get(), (ISearchCriteriaProvider)this);
        AtsSearchDataResults results = query.performSearch();
        if (results.getRd().isErrors()) {
            XResultDataUI.report((XResultData)results.getRd(), (String)this.getName());
        }
        return Collections.castAll((Collection)results.getArtifacts());
    }

    protected void performSearch(IAtsQuery query) {
    }

    @Override
    public WorldUISearchItem copy() {
        return new WorldSearchItem(this.data);
    }

    public AtsSearchData getData() {
        return this.data;
    }

    public void andCriteria(IAtsQuery query) {
        this.performSearch(query);
    }
}

