/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import java.util.Collection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osee.ats.api.util.AttributeValues;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredListDialog;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class AttributeTypeFilteredDialog
extends FilteredListDialog<AttributeTypeToken> {
    private AttributeValues.AttrValueType attrValueType = AttributeValues.AttrValueType.Value;
    private Button existsButton;
    private Button notExistsButton;
    private Button existsValue;
    private Button notExistsValue;

    public AttributeTypeFilteredDialog(Collection<AttributeTypeToken> attributeTypes) {
        super("Select Attribute Type", "Select Attribute Type", (ILabelProvider)new AttributeTypeLabelProvider());
        this.setInput(attributeTypes);
    }

    protected Control createDialogArea(Composite container) {
        Control control = super.createDialogArea(container);
        Composite composite = new Composite((Composite)control, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData());
        this.existsButton = new Button(composite, 32);
        this.notExistsButton = new Button(composite, 32);
        this.existsValue = new Button(composite, 32);
        this.notExistsValue = new Button(composite, 32);
        this.existsButton.setText("Attribute exist");
        this.existsButton.setSelection(false);
        this.existsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeTypeFilteredDialog.this.attrValueType = AttributeValues.AttrValueType.AttrExists;
                AttributeTypeFilteredDialog.this.updateButtons();
            }
        });
        this.notExistsButton.setText("Attribute does not exist");
        this.notExistsButton.setSelection(false);
        this.notExistsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeTypeFilteredDialog.this.attrValueType = AttributeValues.AttrValueType.AttrNotExists;
                AttributeTypeFilteredDialog.this.updateButtons();
            }
        });
        this.existsValue.setText("Attribute exists with value");
        this.existsValue.setSelection(false);
        this.existsValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeTypeFilteredDialog.this.attrValueType = AttributeValues.AttrValueType.AttrExistsValue;
                AttributeTypeFilteredDialog.this.updateButtons();
            }
        });
        this.notExistsValue.setText("Attribute value does not exist");
        this.notExistsValue.setSelection(false);
        this.notExistsValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeTypeFilteredDialog.this.attrValueType = AttributeValues.AttrValueType.AttrNotExistsValue;
                AttributeTypeFilteredDialog.this.updateButtons();
            }
        });
        return control;
    }

    public void updateButtons() {
        Button okButton = this.getOkButton();
        if (Widgets.isAccessible((Widget)okButton)) {
            boolean enabled = false;
            if (this.getSelectedType().isValid() && this.attrValueType != null) {
                enabled = true;
            }
            okButton.setEnabled(enabled);
        }
    }

    public AttributeTypeToken getSelectedType() {
        return (AttributeTypeToken)this.getSelected();
    }

    public final AttributeValues.AttrValueType getAttrValueType() {
        return this.attrValueType;
    }

    public final void setAttrValueType(AttributeValues.AttrValueType attrValueType) {
        this.attrValueType = attrValueType;
    }

    public boolean isExistsValue() {
        return this.attrValueType == AttributeValues.AttrValueType.AttrExistsValue;
    }

    public boolean isNonExists() {
        return this.attrValueType == AttributeValues.AttrValueType.AttrNotExists;
    }

    public boolean isExists() {
        return this.attrValueType == AttributeValues.AttrValueType.AttrExists;
    }

    public boolean isValue() {
        return this.attrValueType == AttributeValues.AttrValueType.Value;
    }

    public static class AttributeTypeLabelProvider
    implements ILabelProvider {
        public String getText(Object arg0) {
            AttributeTypeToken type = (AttributeTypeToken)arg0;
            if (Strings.isValid((String)type.getDescription())) {
                return String.format("%s - %s", type.getName(), type.getDescription());
            }
            return type.getName();
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

