/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.XVersionList;
import org.eclipse.osee.ats.ide.util.widgets.XAtsProgramComboWidget;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.define.ide.traceability.RequirementTraceabilityData;
import org.eclipse.osee.define.ide.traceability.ScriptTraceabilityOperation;
import org.eclipse.osee.define.ide.traceability.TraceUnitExtensionManager;
import org.eclipse.osee.define.ide.traceability.TraceabilityProviderOperation;
import org.eclipse.osee.define.ide.traceability.report.RequirementStatus;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.OteArtifactTypes;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DetailedTestStatusOld
extends AbstractBlam {
    private static final String REQUIREMENTS_BRANCH = "Requirements Branch";
    private static final String PROGRAM = "Program";
    private static final Pattern taskNamePattern = Pattern.compile("(?:\"([^\"]+)\")? for \"([^\"]+)\"");
    private final Matcher taskNameMatcher = taskNamePattern.matcher("");
    private CharBackedInputStream charBak;
    private ISheetWriter excelWriter;
    private final CompositeKeyHashMap<String, String, RequirementStatus> reqTaskMap = new CompositeKeyHashMap();
    private final StringBuilder sumFormula = new StringBuilder(500);
    private HashCollectionSet<Artifact, String> requirementToCodeUnitsMap;
    private final HashMap<String, String> testProcedureInfo = new HashMap();
    private final HashCollection<String, AtsUser> legacyIdToImplementers = new HashCollection();
    private final HashMap<String, Artifact> testRunArtifacts = new HashMap();
    private final HashMap<String, String> scriptCategories = new HashMap();
    private final HashSet<AtsUser> testPocs = new HashSet();
    private final HashSet<String> requirementPocs = new HashSet();
    private final ArrayList<String[]> statusLines = new ArrayList();
    private final ArrayList<RequirementStatus> statuses = new ArrayList(100);
    private Collection<IAtsVersion> versions;
    private XBranchSelectWidget requirementsBranchWidget;
    private XBranchSelectWidget testProcedureBranchWidget;
    private XVersionList versionsListViewer;
    private static final String TRACE_HANDLER_CHECKBOX = "<XWidget xwidgetType=\"XCheckBox\" displayName=\"%s\" labelAfter=\"true\" horizontalLabel=\"true\"/>";
    private Collection<String> availableTraceHandlers;
    private XCombo branchViewWidget;
    private XBranchSelectWidget branchWidget;
    private BranchToken selectedBranch;
    private IAtsProgram selectedProgram;
    private static final int MAX_EXCEL_COLUMNS = 256;
    private final BranchChangeListener branchSelectionListener = new BranchChangeListener();

    public static SimpleDateFormat getDateFormatter() {
        return new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy");
    }

    private void init() throws IOException {
        this.charBak = new CharBackedInputStream();
        this.excelWriter = new ExcelXmlWriter(this.charBak.getWriter());
        this.reqTaskMap.clear();
        this.testRunArtifacts.clear();
        this.testProcedureInfo.clear();
        this.legacyIdToImplementers.clear();
    }

    private String getScriptName(String scriptPath) {
        return scriptPath.substring(scriptPath.lastIndexOf(File.separatorChar) + 1, scriptPath.length() - ".java".length());
    }

    private void loadTestRunArtifacts(BranchId scriptsBranch) {
        List testRuns = ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)OteArtifactTypes.TestRun, (BranchId)scriptsBranch, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED);
        for (Artifact testRun : testRuns) {
            String shortName = testRun.getName();
            Artifact previousTestRun = this.testRunArtifacts.put(shortName = shortName.substring(shortName.lastIndexOf(46) + 1), testRun);
            if (previousTestRun == null) continue;
            Date date = new ArtifactTestRunOperator(testRun).getEndDate();
            Date previousDate = new ArtifactTestRunOperator(previousTestRun).getEndDate();
            if (!previousDate.after(date)) continue;
            this.testRunArtifacts.put(shortName, previousTestRun);
        }
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        if (!this.blamReadyToExecute()) {
            monitor.setCanceled(true);
            return;
        }
        BranchToken requirementsBranch = variableMap.getBranch(REQUIREMENTS_BRANCH);
        BranchToken scriptsBranch = variableMap.getBranch("Test Results Branch");
        BranchToken procedureBranch = variableMap.getBranch("Test Procedure Branch");
        Object view = variableMap.getValue("Branch View");
        this.setViewId(view);
        File scriptDir = new File(variableMap.getString("Script Root Directory"));
        this.versions = new ArrayList<IAtsVersion>();
        for (IAtsVersion version : variableMap.getCollection(IAtsVersion.class, "Versions")) {
            this.versions.add(version);
        }
        this.init();
        this.loadTestRunArtifacts((BranchId)scriptsBranch);
        LinkedList<TraceUnitExtensionManager.TraceHandler> traceHandlers = new LinkedList<TraceUnitExtensionManager.TraceHandler>();
        for (String handler : this.availableTraceHandlers) {
            if (!variableMap.getBoolean(handler)) continue;
            TraceUnitExtensionManager.TraceHandler traceHandler = TraceUnitExtensionManager.getInstance().getTraceHandlerByName(handler);
            traceHandlers.add(traceHandler);
        }
        ScriptTraceabilityOperation provider = new ScriptTraceabilityOperation(scriptDir, (BranchId)requirementsBranch, false, traceHandlers, false, (ArtifactId)this.viewId, false);
        RequirementTraceabilityData traceabilityData = new RequirementTraceabilityData((BranchId)procedureBranch, (TraceabilityProviderOperation)provider, (ArtifactId)this.viewId);
        IStatus status = traceabilityData.initialize(monitor);
        switch (status.getSeverity()) {
            case 0: {
                this.requirementToCodeUnitsMap = traceabilityData.getRequirementsToCodeUnits();
                this.loadReqTaskMap();
                this.writeStatusSheet(traceabilityData.getAllSwRequirements());
                this.writeTestScriptSheet(traceabilityData.getCodeUnits());
                this.excelWriter.endWorkbook();
                IFile iFile = OseeData.getIFile((String)("Detailed_Test_Status_" + Lib.getDateTimeString() + ".xml"));
                AIFile.writeToFile((IFile)iFile, (InputStream)this.charBak);
                Program.launch((String)iFile.getLocation().toOSString());
                break;
            }
            case 8: {
                monitor.setCanceled(true);
                break;
            }
            default: {
                throw new OseeCoreException(status.getMessage(), status.getException());
            }
        }
    }

    private boolean blamReadyToExecute() {
        boolean ready;
        final ArrayList<String> items = new ArrayList<String>();
        if (this.selectedProgram == null) {
            items.add("program");
        }
        if (this.selectedBranch == null) {
            items.add("branch");
        }
        if (!(ready = items.isEmpty())) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Displays.getActiveShell(), (String)"Problem", (String)String.format("Select a %s ...", Strings.buildStatment((List)items)));
                }
            });
        }
        return ready;
    }

    private void writeTestScriptSheet(Set<String> scripts) throws IOException {
        this.excelWriter.startSheet("Scripts", 8);
        this.excelWriter.writeRow(new Object[]{"Category", CoreArtifactTypes.TestCase.getName(), "Run Date", "Total Test Points", "Failed Test Points", "Duration", "Aborted", "Last Author"});
        for (String scriptPath : scripts) {
            String scriptName = this.getScriptName(scriptPath);
            Artifact testRunArtifact = this.testRunArtifacts.get(scriptName);
            String totalTestPoints = null;
            String failedTestPoints = null;
            String category = this.scriptCategories.get(scriptPath);
            String runDate = null;
            String duration = null;
            String aborated = null;
            String lastAuthor = null;
            if (testRunArtifact != null) {
                ArtifactTestRunOperator runOperator = new ArtifactTestRunOperator(testRunArtifact);
                try {
                    runDate = DetailedTestStatusOld.getDateFormatter().format(runOperator.getEndDate());
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
                totalTestPoints = String.valueOf(runOperator.getTotalTestPoints());
                failedTestPoints = String.valueOf(runOperator.getTestPointsFailed());
                duration = runOperator.getRunDuration();
                aborated = runOperator.wasAborted() ? "aborted" : null;
                lastAuthor = runOperator.getLastAuthor();
            }
            this.excelWriter.writeRow(new Object[]{category, scriptName, runDate, totalTestPoints, failedTestPoints, duration, aborated, lastAuthor});
        }
        this.excelWriter.endSheet();
    }

    private void writeStatusSheet(Collection<Artifact> requirements) throws IOException {
        this.excelWriter.startSheet("SW Req Status", 256);
        this.excelWriter.writeRow(new Object[]{null, null, null, null, "Hours per UI per RPCR", "=4"});
        this.excelWriter.writeRow(new Object[]{null, null, null, null, "Hours to integrate all scripts for a UI", "=11"});
        this.excelWriter.writeRow(new Object[]{null, null, null, null, "Hours to develop a new script", "=20"});
        this.excelWriter.writeRow(new Object[0]);
        this.excelWriter.writeRow(new Object[0]);
        this.excelWriter.writeRow(new Object[]{"Category", "Test POCs", CoreAttributeTypes.Partition.getName(), CoreAttributeTypes.Subsystem.getName(), "Requirement Name", CoreAttributeTypes.QualificationMethod.getName(), "Requirement POCs", "SW Enhancement", CoreArtifactTypes.TestProcedure.getName(), CoreArtifactTypes.TestCase.getName(), "Run Date", "Total Test Points", "Failed Test Points", "Hours Remaining", "RPCR", "Hours", "Resolution by Partition"});
        for (Artifact requirement : requirements) {
            this.writeRequirementStatusLines(requirement);
        }
        this.excelWriter.endSheet();
    }

    private void setScriptCategories(Artifact requirement, Collection<String> scripts) {
        try {
            String reqCategory = (String)requirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Category, (Object)"");
            for (String scriptPath : scripts) {
                String scriptCategory = this.scriptCategories.get(scriptPath);
                if (scriptCategory != null && scriptCategory.compareTo(reqCategory) <= 0) continue;
                this.scriptCategories.put(scriptPath, reqCategory);
            }
        }
        catch (Exception exception) {}
    }

    private void processRpcrStatuses(Artifact requirement, String[] statusLine) {
        int columnIndex = Index.HOURS_REMAINING.ordinal() + 1;
        this.sumFormula.append(",");
        for (String requirementName : this.getAliases(requirement)) {
            List tempStatuses = this.reqTaskMap.getValues((Object)requirementName);
            if (tempStatuses == null) continue;
            this.statuses.clear();
            this.statuses.addAll(tempStatuses);
            java.util.Collections.sort(this.statuses);
            int i = this.statuses.size() - 1;
            while (i >= 0) {
                RequirementStatus status = this.statuses.get(i);
                statusLine[columnIndex++] = status.getLegacyId();
                statusLine[columnIndex++] = "=R1C6*(100-" + status.getRolledupPercentComplete() + ")/100";
                this.sumFormula.append("RC");
                this.sumFormula.append(columnIndex);
                this.sumFormula.append(",");
                statusLine[columnIndex++] = status.getPartitionStatuses();
                Collection implementers = this.legacyIdToImplementers.getValues((Object)status.getLegacyId());
                if (implementers != null) {
                    for (AtsUser implementer : implementers) {
                        this.requirementPocs.add(implementer.getName());
                    }
                }
                this.testPocs.addAll(status.getTestPocs());
                --i;
            }
        }
        this.sumFormula.setCharAt(this.sumFormula.length() - 1, ')');
    }

    private void processTestScriptsAndProcedures(Artifact requirement, String[] statusLine) {
        Collection scripts = this.requirementToCodeUnitsMap.getValues((Object)requirement);
        if (scripts == null) {
            if (requirement.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.IndirectSoftwareRequirementMsWord}) || requirement.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractImplementationDetails})) {
                statusLine[Index.TEST_SCRIPT.ordinal()] = requirement.getArtifactTypeName();
                this.sumFormula.insert(0, "=sum(0");
                statusLine[Index.HOURS_REMAINING.ordinal()] = this.sumFormula.toString();
            } else {
                statusLine[Index.TEST_SCRIPT.ordinal()] = "No script found";
                statusLine[Index.HOURS_REMAINING.ordinal()] = "=R3C6";
            }
            this.statusLines.add(statusLine);
        } else {
            this.setScriptCategories(requirement, scripts);
            int testPointTotalForScripts = 0;
            int testPointFailsForScripts = 0;
            for (String script : scripts) {
                String scriptName;
                statusLine[Index.TEST_SCRIPT.ordinal()] = scriptName = this.getScriptName(script);
                Artifact testRunArtifact = this.testRunArtifacts.get(scriptName);
                if (testRunArtifact != null) {
                    ArtifactTestRunOperator runOperator = new ArtifactTestRunOperator(testRunArtifact);
                    try {
                        statusLine[Index.RUN_DATE.ordinal()] = DetailedTestStatusOld.getDateFormatter().format(runOperator.getEndDate());
                    }
                    catch (Exception ex) {
                        this.log(ex);
                    }
                    if (runOperator.wasAborted()) {
                        statusLine[Index.TOTAL_TP.ordinal()] = "Aborted";
                        statusLine[Index.FAILED_TP.ordinal()] = "Aborted";
                    } else {
                        int individualTestPointsFailed = runOperator.getTestPointsFailed();
                        int individualTestPointTotal = runOperator.getTotalTestPoints();
                        statusLine[Index.TOTAL_TP.ordinal()] = String.valueOf(individualTestPointTotal);
                        statusLine[Index.FAILED_TP.ordinal()] = String.valueOf(individualTestPointsFailed);
                        testPointFailsForScripts += individualTestPointsFailed;
                        testPointTotalForScripts += individualTestPointTotal;
                    }
                }
                this.statusLines.add(statusLine);
                String[] oldStatusLine = statusLine;
                statusLine = new String[100];
                this.initStatusLine(oldStatusLine, statusLine);
            }
            String failRatio = "1";
            if (testPointTotalForScripts != 0) {
                failRatio = String.valueOf(testPointFailsForScripts) + "/" + testPointTotalForScripts;
            }
            this.sumFormula.insert(0, "=sum(R2C6*" + failRatio);
            this.statusLines.get((int)0)[Index.HOURS_REMAINING.ordinal()] = this.sumFormula.toString();
        }
    }

    private void writeRequirementStatusLines(Artifact requirement) throws IOException {
        this.statusLines.clear();
        this.testPocs.clear();
        this.requirementPocs.clear();
        this.sumFormula.delete(0, 99999);
        String[] statusLine = new String[256];
        this.processRpcrStatuses(requirement, statusLine);
        statusLine[Index.Category.ordinal()] = (String)requirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Category, (Object)"");
        if (requirement.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.IndirectSoftwareRequirementMsWord}) || requirement.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractImplementationDetails})) {
            statusLine[Index.Category.ordinal()] = "I";
        }
        statusLine[Index.TEST_POC.ordinal()] = AtsObjects.toString((String)"; ", this.testPocs);
        statusLine[Index.PARTITION.ordinal()] = requirement.getAttributesToString((AttributeTypeId)CoreAttributeTypes.Partition);
        statusLine[Index.SUBSYSTEM.ordinal()] = (String)requirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)"");
        statusLine[Index.REQUIREMENT_NAME.ordinal()] = requirement.getName();
        statusLine[Index.QUALIFICATION_METHOD.ordinal()] = requirement.getAttributesToStringSorted((AttributeTypeId)CoreAttributeTypes.QualificationMethod);
        statusLine[Index.REQUIREMENT_POC.ordinal()] = Collections.toString((String)",", this.requirementPocs);
        List reqStats = this.reqTaskMap.getValues((Object)requirement.getName());
        statusLine[Index.SW_ENHANCEMENT.ordinal()] = reqStats.isEmpty() ? "" : ((RequirementStatus)reqStats.iterator().next()).getSwEnhancement();
        this.processTestScriptsAndProcedures(requirement, statusLine);
        for (Object[] objectArray : this.statusLines) {
            this.excelWriter.writeRow(objectArray);
        }
    }

    private void initStatusLine(String[] oldStatusLine, String[] newStatusLine) {
        System.arraycopy(oldStatusLine, 0, newStatusLine, 0, Index.RUN_DATE.ordinal());
    }

    private void loadReqTaskMap() throws Exception {
        for (IAtsVersion version : this.versions) {
            for (IAtsTeamWorkflow workflow : AtsApiService.get().getVersionService().getTargetedForTeamWorkflows(version)) {
                this.loadTasksFromWorkflow((TeamWorkFlowArtifact)workflow.getStoreObject());
            }
        }
    }

    public void widgetCreating(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        String widgetLabel = xWidget.getLabel();
        if (widgetLabel.equals("Versions")) {
            this.versionsListViewer = (XVersionList)xWidget;
        } else if (widgetLabel.equals(REQUIREMENTS_BRANCH)) {
            this.requirementsBranchWidget = (XBranchSelectWidget)xWidget;
        } else if (widgetLabel.equals("Test Procedure Branch")) {
            this.testProcedureBranchWidget = (XBranchSelectWidget)xWidget;
        }
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        String widgetName = xWidget.getLabel();
        if (widgetName.equals(PROGRAM)) {
            XAtsProgramComboWidget programWidget = (XAtsProgramComboWidget)xWidget;
            programWidget.getComboViewer().addSelectionChangedListener((ISelectionChangedListener)new ProgramSelectionListener());
        } else if (xWidget.getLabel().equals(REQUIREMENTS_BRANCH)) {
            this.branchWidget = (XBranchSelectWidget)xWidget;
            this.branchWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (DetailedTestStatusOld.this.branchViewWidget != null) {
                        DetailedTestStatusOld.this.branchViewWidget.setEditable(true);
                        BranchToken branch = DetailedTestStatusOld.this.branchWidget.getSelection();
                        if (branch != null && branch.isValid()) {
                            DetailedTestStatusOld.this.branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)ViewApplicabilityUtil.getParentBranch((BranchId)branch));
                            DetailedTestStatusOld.this.branchViewWidget.setDataStrings(DetailedTestStatusOld.this.branchViews.values());
                        }
                    }
                }
            });
        } else if (xWidget.getLabel().equals("Branch View")) {
            this.branchViewWidget = (XCombo)xWidget;
            this.branchViewWidget.setEditable(false);
        }
    }

    private void loadTasksFromWorkflow(TeamWorkFlowArtifact workflow) {
        Collection tasks = AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)workflow);
        String legacyId = (String)workflow.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.LegacyPcrId, "");
        List<AtsUser> implementers = workflow.getImplementers();
        this.legacyIdToImplementers.put((Object)legacyId, implementers);
        for (IAtsTask task : tasks) {
            this.taskNameMatcher.reset(task.getName());
            if (this.taskNameMatcher.find()) {
                String requirementName = this.taskNameMatcher.group(2);
                RequirementStatus requirementStatus = (RequirementStatus)this.reqTaskMap.get((Object)requirementName, (Object)legacyId);
                if (requirementStatus == null) {
                    requirementStatus = new RequirementStatus(requirementName, legacyId, workflow.getSoleAttributeValueAsString((AttributeTypeToken)AtsAttributeTypes.SwEnhancement, ""));
                    this.reqTaskMap.put((Object)requirementName, (Object)legacyId, (Object)requirementStatus);
                }
                int percentComplete = AtsApiService.get().getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)task);
                requirementStatus.addPartitionStatus(percentComplete, this.taskNameMatcher.group(1), task.getCurrentStateName());
                requirementStatus.setTestPocs((Collection)task.getImplementers());
                continue;
            }
            this.logf("odd task:  [%s]", new Object[]{task.getName()});
        }
    }

    private Collection<String> getAliases(Artifact artifact) {
        ArrayList<String> aliases = new ArrayList<String>(1);
        aliases.add(artifact.getName());
        return aliases;
    }

    public String getXWidgetsXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xWidgets>");
        sb.append("<XWidget xwidgetType=\"XAtsProgramComboWidget\" horizontalLabel=\"true\" displayName=\"Program\" />");
        sb.append("<XWidget xwidgetType=\"XVersionList\" displayName=\"Versions\" multiSelect=\"true\" />");
        sb.append("<XWidget xwidgetType=\"XText\" displayName=\"Script Root Directory\" defaultValue=\"C:/UserData/workspaceScripts\" />");
        this.availableTraceHandlers = new LinkedList<String>();
        sb.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select appropriate script parser:\" />");
        List traceHandlers = TraceUnitExtensionManager.getInstance().getAllTraceHandlerNames();
        for (String handler : traceHandlers) {
            sb.append(String.format(TRACE_HANDLER_CHECKBOX, handler));
            this.availableTraceHandlers.add(handler);
        }
        sb.append("<XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Requirements Branch\" toolTip=\"Select a requirements branch.\" />");
        sb.append("<XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Test Results Branch\" toolTip=\"Select a scripts results branch.\" />");
        sb.append("<XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Test Procedure Branch\" toolTip=\"Select a test procedures branch.\" />");
        sb.append("<XWidget xwidgetType=\"XCombo()\" displayName=\"Branch View\" horizontalLabel=\"true\"/>");
        sb.append("</xWidgets>");
        return sb.toString();
    }

    public String getDescriptionUsage() {
        return "Generates an excel spreadsheet with detailed test status for scripts and procedures";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.OTE);
    }

    private class BranchChangeListener
    implements ISelectionChangedListener {
        private BranchChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection versionArtifactSelection = (IStructuredSelection)event.getSelectionProvider().getSelection();
            Iterator iter = versionArtifactSelection.iterator();
            if (iter.hasNext()) {
                IAtsVersion version = (IAtsVersion)iter.next();
                try {
                    if (version != null) {
                        DetailedTestStatusOld.this.selectedBranch = BranchManager.getBranchToken((BranchId)AtsApiService.get().getVersionService().getBaselineBranchIdInherited(version));
                        DetailedTestStatusOld.this.requirementsBranchWidget.setSelection(DetailedTestStatusOld.this.selectedBranch);
                        DetailedTestStatusOld.this.testProcedureBranchWidget.setSelection(DetailedTestStatusOld.this.selectedBranch);
                    }
                }
                catch (OseeCoreException ex) {
                    DetailedTestStatusOld.this.log(ex);
                }
            }
        }
    }

    private static enum Index {
        Category,
        TEST_POC,
        PARTITION,
        SUBSYSTEM,
        REQUIREMENT_NAME,
        QUALIFICATION_METHOD,
        REQUIREMENT_POC,
        SW_ENHANCEMENT,
        TEST_PROCEDURE,
        TEST_SCRIPT,
        RUN_DATE,
        TOTAL_TP,
        FAILED_TP,
        HOURS_REMAINING;

    }

    private class ProgramSelectionListener
    implements ISelectionChangedListener {
        private ProgramSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelectionProvider().getSelection();
            Iterator iter = selection.iterator();
            if (iter.hasNext()) {
                DetailedTestStatusOld.this.selectedProgram = (IAtsProgram)iter.next();
                DetailedTestStatusOld.this.selectedBranch = null;
                try {
                    Collection versionArtifacts = AtsApiService.get().getProgramService().getVersions(DetailedTestStatusOld.this.selectedProgram);
                    DetailedTestStatusOld.this.versionsListViewer.setInputAtsObjects(versionArtifacts);
                    DetailedTestStatusOld.this.requirementsBranchWidget.setSelection(null);
                    DetailedTestStatusOld.this.testProcedureBranchWidget.setSelection(null);
                    DetailedTestStatusOld.this.versionsListViewer.addSelectionChangedListener(DetailedTestStatusOld.this.branchSelectionListener);
                }
                catch (OseeCoreException ex) {
                    DetailedTestStatusOld.this.log(ex);
                }
            }
        }
    }
}

