/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.notify.TestEmail;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.util.OseeEmail;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.notify.OseeEmailIde;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class TestEmailSend
extends XNavigateItemAction {
    private static final String TITLE = "Test Email Send";
    AtsApi atsApi = AtsApiService.get();
    private XResultData rd;

    public TestEmailSend() {
        super(TITLE, (KeyedImage)FrameworkImage.EMAIL, new XNavItemCat[]{XNavigateItem.EMAIL_NOTIFICATIONS});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        try {
            this.rd = new XResultData();
            this.rd.logf("%s\n\n", new Object[]{this.getName()});
            User user = UserManager.getUser();
            if (user.isInvalid()) {
                this.rd.errorf(TITLE, new Object[]{"User [%s] is invalid", user});
            }
            this.testBasicEmail(user);
            XResultDataUI.report((XResultData)this.rd, (String)this.getName());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private void testBasicEmail(User user) {
        String email = user.getEmail();
        if (!EmailUtil.isEmailValid((String)email)) {
            XResultDataUI.errorf((String)TITLE, (String)"User email [%s] is invalid", (Object[])new Object[]{user});
            return;
        }
        this.rd.log("1. Two basic \"Hello World\" emails should be sent; one from client and another from server.\n\n");
        String title = "Send Test Email - Client";
        this.rd.log(title);
        try {
            OseeEmailIde emailMessage = OseeEmailIde.create(Arrays.asList(email), (String)email, (String)email, (String)title, (String)AHTML.simplePage((String)AHTML.bold((String)"Hello World - this should be bold")), (OseeEmail.BodyType)OseeEmail.BodyType.Html, Arrays.asList(email), (String)("Abridged - " + title));
            emailMessage.send();
            this.rd.log("Completed");
        }
        catch (Exception ex) {
            this.rd.error(Lib.exceptionToString((Exception)ex));
        }
        this.rd.log("\n\n2. If Abridged Email attribute is set on your user artifact, another two emails should be sent from client and server with only basic information about the change (eg: Simple title, NO description, etc).\n\n");
        String title2 = "Send Test Email - Server";
        this.rd.log(title2);
        try {
            XResultData remoteRd = this.atsApi.getServerEndpoints().getNotifyEndpoint().sendTestEmail(TestEmail.create((String)email, (String)title2));
            this.rd.merge(remoteRd);
        }
        catch (Exception ex) {
            this.rd.error(Lib.exceptionToString((Exception)ex));
        }
        this.rd.log("Completed");
    }
}

