/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.column.ChangeTypeColumn;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.actions.newaction.NewActionJob;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.WorldXNavigateItemAction;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Shell;

public class AtsRemoteEventTestItem
extends WorldXNavigateItemAction {
    XResultData resultData;
    ArtifactToken SAW_Bld_1 = ArtifactToken.valueOf((long)2749182L, (String)"SAW_Bld_1", (BranchToken)CoreBranches.COMMON, (ArtifactTypeToken)AtsArtifactTypes.Version);
    ArtifactToken SAW_Bld_2 = ArtifactToken.valueOf((long)7632957L, (String)"SAW_Bld_2", (BranchToken)CoreBranches.COMMON, (ArtifactTypeToken)AtsArtifactTypes.Version);
    ArtifactToken SAW_Bld_3 = ArtifactToken.valueOf((long)577781L, (String)"SAW_Bld_3", (BranchToken)CoreBranches.COMMON, (ArtifactTypeToken)AtsArtifactTypes.Version);

    public AtsRemoteEventTestItem() {
        super("ATS Remote Event Test", XNavigateItem.TOP_ADMIN);
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        EntryDialog diag;
        if (AtsApiService.get().getStoreService().isProductionDb()) {
            AWorkbench.popup((String)"ERROR", (String)"This should not to be run on production DB");
            return;
        }
        MessageDialog dialog = new MessageDialog(Displays.getActiveShell(), this.getName(), null, String.valueOf(this.getName()) + "\n\nSelect Source or Destination Client", 3, new String[]{"Source Client", "Destination Client - Start", "Destination Client - End", "Cancel"}, 2);
        int result = dialog.open();
        this.resultData = new XResultData();
        if (result == 0) {
            this.runClientTest();
        } else if (result == 1) {
            EntryDialog diag2 = new EntryDialog(this.getName(), "Enter tt number of Source Client created Action");
            if (diag2.open() == 0) {
                this.runDestinationTestStart(diag2.getEntry());
            }
        } else if (result == 2 && (diag = new EntryDialog(this.getName(), "Enter tt number of Source Client created Action")).open() == 0) {
            this.runDestinationTestEnd(diag.getEntry());
        }
    }

    private static Set<IAtsActionableItem> getActionableItems() {
        HashSet<IAtsActionableItem> aias = new HashSet<IAtsActionableItem>();
        IAtsActionableItem sawCodeAi = (IAtsActionableItem)AtsApiService.get().getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andName("SAW Code").getConfigObjectResultSet().getAtMostOneOrDefault((Object)IAtsActionableItem.SENTINEL);
        Conditions.assertNotSentinel((Id)sawCodeAi, (String)"SAW Code AI; DBInit should be Demo DbInit");
        aias.add(sawCodeAi);
        return aias;
    }

    private void runClientTest() {
        String title = String.valueOf(this.getName()) + " - Destination Client Test";
        this.resultData.log("Running " + title);
        NewActionJob job = null;
        job = new NewActionJob("tt", "description", ChangeTypes.Improvement, "1", null, false, AtsRemoteEventTestItem.getActionableItems(), null);
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        IAtsAction action = job.getResults().getAction();
        this.resultData.log("Created Action " + action.toStringWithId());
        TeamWorkFlowArtifact teamWf = (TeamWorkFlowArtifact)((IAtsTeamWorkflow)job.getResults().getTeamWfs().iterator().next()).getStoreObject();
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " - set assignee");
        changes.addAssignee((IAtsWorkItem)teamWf, AtsApiService.get().getUserService().getCurrentUser());
        changes.execute();
        this.validateActionAtStart(teamWf);
        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getName(), (String)("Launch \"Destination Client - Start\" test, enter \"" + action.getName().replaceFirst("tt ", "") + "\" and press Ok"))) {
            return;
        }
        int sleepTime = 250;
        this.makeChanges1(teamWf);
        AtsRemoteEventTestItem.sleep(sleepTime);
        this.makeChanges2(teamWf);
        AtsRemoteEventTestItem.sleep(sleepTime);
        this.makeChanges3(teamWf);
        AtsRemoteEventTestItem.sleep(sleepTime);
        this.makeChanges4(teamWf);
        AtsRemoteEventTestItem.sleep(sleepTime);
        this.makeChanges5(teamWf);
        AtsRemoteEventTestItem.sleep(sleepTime);
        this.makeChanges6(teamWf);
        AtsRemoteEventTestItem.sleep(sleepTime);
        this.makeChanges7(teamWf);
        AtsRemoteEventTestItem.sleep(sleepTime);
        this.validateActionAtEnd(teamWf);
        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getName(), (String)("Launch \"Destination Client - End\" test, enter \"" + action.getName().replaceFirst("tt ", "") + "\" and press Ok"))) {
            return;
        }
        XResultDataUI.report((XResultData)this.resultData, (String)title);
    }

    public static void sleep(long milliseconds) {
        try {
            System.out.println("Sleeping " + milliseconds);
            Thread.sleep(milliseconds);
            System.out.println("Awake");
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void makeChanges7(IAtsTeamWorkflow teamWf) {
        TransitionData helper = new TransitionData("Remote Event Test", Arrays.asList(teamWf), TeamState.Analyze.getName(), Collections.singleton(AtsApiService.get().getUserService().getCurrentUser()), null, null, new TransitionOption[]{TransitionOption.None});
        TransitionResults results = AtsApiService.get().getWorkItemServiceIde().transition(helper);
        if (!results.isEmpty()) {
            throw new OseeStateException(results.toString(), new Object[0]);
        }
    }

    private void makeChanges6(IAtsTeamWorkflow teamWf) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " Changes6");
        AtsApiService.get().getVersionService().setTargetedVersion(teamWf, this.getSawBld2(), changes);
        changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.ValidationRequired, "false");
        changes.execute();
    }

    private void makeChanges5(IAtsTeamWorkflow teamWf) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " Changes5");
        changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.ValidationRequired, "true");
        changes.execute();
    }

    private void makeChanges4(IAtsTeamWorkflow teamWf) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " Changes4");
        changes.deleteAttributes((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.ValidationRequired);
        changes.deleteAttributes((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.Resolution);
        changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.Description, "description 4");
        ChangeTypeColumn.setChangeType((IAtsObject)teamWf, (ChangeTypes)ChangeTypes.Support, (IAtsChangeSet)changes);
        changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.Priority, "3");
        AtsApiService.get().getVersionService().setTargetedVersion(teamWf, this.getSawBld3(), changes);
        changes.execute();
    }

    private void makeChanges3(IAtsTeamWorkflow teamWf) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " Changes3");
        AtsApiService.get().getVersionService().setTargetedVersion(teamWf, this.getSawBld2(), changes);
        changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.ValidationRequired, "false");
        changes.execute();
    }

    private void makeChanges2(IAtsTeamWorkflow teamWf) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " Changes2");
        changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.Description, "description 3");
        changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.ProposedResolution, "this is resolution");
        changes.execute();
    }

    private void makeChanges1(IAtsTeamWorkflow teamWf) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " Changes1");
        changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.Description, "description 2");
        changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.ChangeType, ChangeTypes.Problem.name());
        changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.Priority, "2");
        changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.ValidationRequired, "true");
        AtsApiService.get().getVersionService().setTargetedVersion(teamWf, this.getSawBld1(), changes);
        changes.execute();
    }

    private IAtsVersion getSawBld1() {
        return AtsApiService.get().getVersionService().getVersionById((ArtifactId)this.SAW_Bld_1);
    }

    private IAtsVersion getSawBld2() {
        return AtsApiService.get().getVersionService().getVersionById((ArtifactId)this.SAW_Bld_2);
    }

    private IAtsVersion getSawBld3() {
        return AtsApiService.get().getVersionService().getVersionById((ArtifactId)this.SAW_Bld_3);
    }

    private void validateActionAtStart(IAtsTeamWorkflow teamWf) {
        this.resultData.log("\nValidating Start...");
        if (!OseeEventManager.isEventManagerConnected()) {
            this.resultData.error("Remote Event Service is not connected");
            return;
        }
        this.resultData.log("Remote Event Service connected");
        this.testEquals("Description", "description", AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.Description, null));
        this.testEquals("Change Type", ChangeTypes.Improvement, ChangeTypeColumn.getChangeType((IAtsWorkItem)teamWf, (AtsApi)AtsApiService.get()));
        this.testEquals("Priority", "1", AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.Priority, null));
    }

    private void validateActionAtEnd(IAtsTeamWorkflow teamWf) {
        this.resultData.log("\nValidating End...");
        if (!OseeEventManager.isEventManagerConnected()) {
            this.resultData.error("Remote Event Service is not connected");
            return;
        }
        this.resultData.log("Remote Event Service connected");
        this.testEquals("Description", "description 4", AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.Description, null));
        this.testEquals("Change Type", ChangeTypes.Support, ChangeTypeColumn.getChangeType((IAtsWorkItem)teamWf, (AtsApi)AtsApiService.get()));
        this.testEquals("Priority", "3", AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.Priority, null));
        this.testEquals("Validation Required", false, AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.ValidationRequired, null));
        IAtsVersion verArt = AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)teamWf);
        String expectedTargetedVersion = verArt != null ? verArt.toString() : "not set";
        this.testEquals("Targeted Version", expectedTargetedVersion, "SAW_Bld_2");
        this.testEquals("State", TeamState.Analyze.getName(), teamWf.getCurrentStateName());
    }

    private void testEquals(String name, Object expected, Object actual) {
        if (!expected.equals(actual)) {
            this.resultData.error(String.format("Error: [%s] - expected [%s] actual[%s]", name, expected, actual));
        } else {
            this.resultData.log(String.format("Valid: [%s] - expected [%s] actual[%s]", name, expected, actual));
        }
    }

    private void runDestinationTestStart(String ttNum) {
        String title = String.valueOf(this.getName()) + " - Destination Client Test - Start";
        String actionTitle = "tt " + ttNum;
        this.resultData.log("Running " + title);
        IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)AtsApiService.get().getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andName(actionTitle).getItems(IAtsTeamWorkflow.class).iterator().next();
        this.resultData.log("Loaded TeamWf " + teamWf);
        AtsEditors.openATSAction(teamWf.getParentAction().getStoreObject(), AtsOpenOption.OpenOneOrPopupSelect);
        this.validateActionAtStart(teamWf);
        XResultDataUI.report((XResultData)this.resultData, (String)title);
    }

    private void runDestinationTestEnd(String ttNum) {
        String title = String.valueOf(this.getName()) + " - Destination Client Test - End";
        String actionTitle = "tt " + ttNum;
        this.resultData.log("Running " + title);
        IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)AtsApiService.get().getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andName(actionTitle).getItems(IAtsTeamWorkflow.class).iterator().next();
        this.resultData.log("Loaded TeamWf " + teamWf);
        AtsEditors.openATSAction(teamWf.getParentAction().getStoreObject(), AtsOpenOption.OpenOneOrPopupSelect);
        this.validateActionAtEnd(teamWf);
        XResultDataUI.report((XResultData)this.resultData, (String)title);
    }
}

