/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.health;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.query.IAtsConfigQuery;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.ide.health.OseeProductionTestProvider;
import org.eclipse.osee.ats.ide.health.StandAloneRestData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.result.IResultDataListener;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Shell;

public class OseeProductionTestsNavItem
extends XNavigateItem {
    public static String NAME = "OSEE Production Tests";
    private final AtsApi atsApi;
    private static IAtsQueryService queryService;
    private final List<StandAloneRestData> datas = new ArrayList<StandAloneRestData>();
    private static final List<OseeProductionTestProvider> providers;

    static {
        providers = new ArrayList<OseeProductionTestProvider>();
    }

    public OseeProductionTestsNavItem() {
        super(NAME, (OseeImage)AtsImage.SEARCH, new XNavItemCat[]{AtsNavigateViewItems.ATS_ADMIN});
        this.atsApi = AtsApiService.get();
        if (this.atsApi != null) {
            queryService = this.atsApi.getQueryService();
        }
    }

    public void addOseeProductionTestProvider(OseeProductionTestProvider provider) {
        providers.add(provider);
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getName(), (String)"Run OSEE Performance Tests against the database\n\nRun with caution to not affect production")) {
            return;
        }
        IResultDataListener listener = new IResultDataListener(){

            public void log(XResultData.Type type, String str) {
            }
        };
        XResultData rd = new XResultData(true, new IResultDataListener[]{listener});
        rd.log(AHTML.beginMultiColumnTable((int)95, (int)1));
        rd.log(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Time(ms)", "Result", "Name", "Type", "Details")));
        ElapsedTime time = new ElapsedTime(" ");
        this.testStandAloneRest(rd);
        this.testAtsConfig(rd);
        this.testAtsTeamDefinition(rd);
        this.testAtsQueries(rd);
        this.testArtifactQueries(rd);
        this.testAtsQuickSearchQueries(rd);
        for (OseeProductionTestProvider provider : providers) {
            provider.testPublishing(rd);
            this.testAtsApiQueries(rd, provider);
        }
        Long ms = time.getTimeSpent();
        rd.log(AHTML.endMultiColumnTable());
        Long sec = ms / 1000L;
        rd.logf(AHTML.addRowMultiColumnTable((String[])new String[]{String.format("Total Time  MS : %s  Sec: %s ", ms.toString(), sec)}), new Object[0]);
        XResultDataUI.report((XResultData)rd, (String)this.getName());
    }

    private void testAtsConfig(XResultData rd) {
        ElapsedTime time = new ElapsedTime("Get ATS Config with Pend");
        AtsApiService.get().getConfigService().getConfigurationsWithPend();
        rd.logf(AHTML.addRowMultiColumnTable((String[])new String[]{time.getTimeSpent().toString(), "PASS", "Get ATS Config with Pend", "JSON", "/ats/config"}), new Object[0]);
    }

    private List<StandAloneRestData> getStandAloneRestCalls() {
        for (OseeProductionTestProvider provider : providers) {
            this.datas.addAll(provider.getStandAloneRestDatas());
        }
        this.datas.add(new StandAloneRestData("ATS New Action", "/ats/ui/action/NewAction", "HTML", "Create new ATS Action"));
        this.datas.add(new StandAloneRestData("ATS Action Endpoint", "/ats/ui/action", "HTML", "ATS UI Endpoint"));
        this.datas.add(new StandAloneRestData("ATS Action Search", "/ats/ui/action/Search", "HTML", "ATS - Search"));
        this.datas.add(new StandAloneRestData("ATS Configure Branch", "/ats/config/ui/NewAtsBranchConfig", "HTML", "ATS - Configure Branch"));
        this.datas.add(new StandAloneRestData("ORCS Branch", "/orcs/branch", "HTML", "Name"));
        this.datas.add(new StandAloneRestData("ATS Health Check", "/ats/health/check", "HTML", "ATS Health Check"));
        this.datas.add(new StandAloneRestData("ATS Config", "/ats/config", "JSON", "\"views\""));
        this.datas.add(new StandAloneRestData("ATS Program", "/ats/program", "JSON", "\"name\""));
        this.datas.add(new StandAloneRestData("ATS Program Details", "/ats/program/details", "JSON", "\"country\""));
        this.datas.add(new StandAloneRestData("ATS Team Details", "/ats/team/details", "JSON", "\"Name\""));
        this.datas.add(new StandAloneRestData("ORCS Branch", "/orcs/branches", "JSON", "\"inheritAccessControl\""));
        this.datas.add(new StandAloneRestData("APPS API", "/apps/api", "JSON", "\"description\""));
        this.datas.add(new StandAloneRestData("ATS AI Details", "/ats/ai/details", "JSON", "\"Description\""));
        this.datas.add(new StandAloneRestData("ATS Country Details", "/ats/country/details", "JSON", "\"programs\""));
        this.datas.add(new StandAloneRestData("ATS Config Validate", "/ats/config/validate", "JSON", "\"numErrorsViaSearch\""));
        this.datas.add(new StandAloneRestData("ORCS Working Branches", "/orcs/branches/working", "JSON", "\"associatedArtifact\""));
        this.datas.add(new StandAloneRestData("ORCS Datastore Info", "/orcs/datastore/info", "JSON", "\"properties\""));
        this.datas.add(new StandAloneRestData("ATS Confg - FAILED", "/ats/confg", "JSON", "items"));
        this.datas.add(new StandAloneRestData("ATS New Action - FAILED", "/ats/ui/action/NewAction", "HTML", "Blah Blah"));
        return this.datas;
    }

    private void testStandAloneRest(XResultData rd) {
        for (StandAloneRestData data : this.getStandAloneRestCalls()) {
            String title = data.getName();
            String url = data.getUrl();
            ElapsedTime time = new ElapsedTime(" ");
            boolean passed = true;
            if (data.getMediaType().equals("HTML")) {
                String html = this.getHtml(url);
                if (!html.contains(data.getResultStr())) {
                    passed = false;
                }
            } else {
                String json = this.getJson(url);
                if (!json.contains(data.getResultStr())) {
                    passed = false;
                }
            }
            Long ms = time.getTimeSpent();
            rd.logf(AHTML.addRowMultiColumnTable((String[])new String[]{ms.toString(), this.getPassFail(passed), title, data.getMediaType(), url}), new Object[0]);
        }
    }

    private String getPassFail(boolean passed) {
        return passed ? "PASS" : AHTML.boldColor((String)"RED", (String)"FAIL");
    }

    protected String getHtml(String url) {
        return this.getAndCheckResponseCode(url, MediaType.TEXT_HTML_TYPE);
    }

    protected String getJson(String url) {
        return this.getAndCheckResponseCode(url, MediaType.APPLICATION_JSON_TYPE);
    }

    private String getAndCheckResponseCode(String path, MediaType mediaType) {
        JaxRsApi jaxRsApi = AtsApiService.get().jaxRsApi();
        return (String)jaxRsApi.newTarget(path).request(new MediaType[]{mediaType}).get().readEntity(String.class);
    }

    private Map<String, IAtsConfigQuery> getAtsWorkItemQueries(OseeProductionTestProvider provider) {
        ArtifactId atsTeamDefId = provider.getAtsWorkItemQueryTeamDef();
        TeamDefinition atsTeamDef = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById(atsTeamDefId);
        HashMap<String, IAtsConfigQuery> queries = new HashMap<String, IAtsConfigQuery>();
        queries.put("Query Working ATS Team Workflows by Team", queryService.createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andAttr((AttributeTypeToken)AtsAttributeTypes.CurrentStateType, StateType.Working.name(), new QueryOption[0]).andAttr((AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, atsTeamDefId.toString(), new QueryOption[0]));
        ArtifactCache.deCache((BranchId)CoreBranches.COMMON);
        ArrayList<String> actionableItems = new ArrayList<String>();
        for (Long id : AtsObjects.toIds((Collection)AtsApiService.get().getActionableItemService().getActionableItems((IAtsTeamDefinition)atsTeamDef))) {
            actionableItems.add(id.toString());
        }
        queries.put("Query Working ATS Team Workflows by AI", queryService.createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andAttr((AttributeTypeToken)AtsAttributeTypes.CurrentStateType, StateType.Working.name(), new QueryOption[0]).andAttr((AttributeTypeToken)AtsAttributeTypes.ActionableItemReference, actionableItems, new QueryOption[0]));
        ArtifactCache.deCache((BranchId)CoreBranches.COMMON);
        queries.put("Query Working Reviews", queryService.createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.PeerToPeerReview}).andAttr((AttributeTypeToken)AtsAttributeTypes.CurrentStateType, StateType.Working.name(), new QueryOption[0]));
        ArtifactCache.deCache((BranchId)CoreBranches.COMMON);
        queries.put("Query By State", queryService.createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andAttr((AttributeTypeToken)AtsAttributeTypes.CurrentStateName, TeamState.Authorize.getName(), new QueryOption[0]));
        return queries;
    }

    private void testAtsApiQueries(XResultData rd, OseeProductionTestProvider provider) {
        for (Map.Entry<String, IAtsConfigQuery> entry : this.getAtsWorkItemQueries(provider).entrySet()) {
            String title = entry.getKey();
            ElapsedTime time = new ElapsedTime(title);
            Collection workItems = entry.getValue().getWorkItems();
            boolean passed = true;
            Long ms = time.getTimeSpent();
            rd.logf(AHTML.addRowMultiColumnTable((String[])new String[]{ms.toString(), this.getPassFail(passed), title, "API", String.valueOf(workItems.size()) + " returned"}), new Object[0]);
        }
    }

    private Map<String, IAtsConfigQuery> getConfigObjectQueries() {
        HashMap<String, IAtsConfigQuery> queries = new HashMap<String, IAtsConfigQuery>();
        queries.put("Team Definition", queryService.createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andWorkType(WorkType.Code, new WorkType[0]));
        queries.put("Team Definition with Name", queryService.createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andAttr((AttributeTypeToken)CoreAttributeTypes.Name, DemoArtifactToken.SAW_Code.getName(), new QueryOption[0]));
        queries.put("Team Definition with ProgramId", queryService.createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andAttr((AttributeTypeToken)AtsAttributeTypes.ProgramId, "Test Program ID", new QueryOption[0]));
        return queries;
    }

    private void testAtsTeamDefinition(XResultData rd) {
        for (Map.Entry<String, IAtsConfigQuery> entry : this.getConfigObjectQueries().entrySet()) {
            String title = entry.getKey();
            ElapsedTime time = new ElapsedTime(title);
            ResultSet teamDefs = entry.getValue().getConfigObjectResultSet();
            entry.getValue().getConfigObjectResultSet().getOneOrDefault((Object)IAtsTeamDefinition.SENTINEL);
            boolean passed = true;
            Long ms = time.getTimeSpent();
            rd.logf(AHTML.addRowMultiColumnTable((String[])new String[]{ms.toString(), this.getPassFail(passed), title, "API", String.valueOf(teamDefs.size()) + " returned"}), new Object[0]);
        }
    }

    private Map<String, IAtsQuery> getAtsQueries() {
        HashMap<String, IAtsQuery> queries = new HashMap<String, IAtsQuery>();
        queries.put("Peer Review WorkItem", queryService.createQuery(WorkItemType.PeerReview, new WorkItemType[0]));
        ArtifactToken version = queryService.getArtifactByName(AtsArtifactTypes.Version, "0.26.0");
        if (version != null) {
            queries.put("Version TeamWorkflow", queryService.createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andVersion(version.getId()));
        }
        return queries;
    }

    private void testAtsQueries(XResultData rd) {
        for (Map.Entry<String, IAtsQuery> entry : this.getAtsQueries().entrySet()) {
            String title = entry.getKey();
            ElapsedTime time = new ElapsedTime(title);
            ResultSet workItems = entry.getValue().getResults();
            boolean passed = true;
            Long ms = time.getTimeSpent();
            rd.logf(AHTML.addRowMultiColumnTable((String[])new String[]{ms.toString(), this.getPassFail(passed), title, "API", String.valueOf(workItems.size()) + " returned"}), new Object[0]);
        }
    }

    private Map<String, QueryBuilderArtifact> getArtifactQueries() {
        QueryBuilderArtifact query1 = ArtifactQuery.createQueryBuilder((BranchId)CoreBranches.COMMON);
        ArrayList<ArtifactId> artIds = new ArrayList<ArtifactId>();
        artIds.add(ArtifactId.valueOf((int)5367053));
        artIds.add(ArtifactId.valueOf((int)10867103));
        query1.andIds(artIds);
        HashMap<String, QueryBuilderArtifact> queries = new HashMap<String, QueryBuilderArtifact>();
        queries.put("Query Artifacts", query1);
        QueryBuilderArtifact query2 = ArtifactQuery.createQueryBuilder((BranchId)CoreBranches.COMMON);
        query2.and((AttributeTypeId)CoreAttributeTypes.Name, "ATS CM Branch", QueryOption.CONTAINS_MATCH_OPTIONS);
        queries.put("Artifact with Attribute", query2);
        return queries;
    }

    private void testArtifactQueries(XResultData rd) {
        for (Map.Entry<String, QueryBuilderArtifact> entry : this.getArtifactQueries().entrySet()) {
            String title = entry.getKey();
            ElapsedTime time = new ElapsedTime(title);
            List artifacts = entry.getValue().getResults().getList();
            boolean passed = true;
            Long ms = time.getTimeSpent();
            rd.logf(AHTML.addRowMultiColumnTable((String[])new String[]{ms.toString(), this.getPassFail(passed), title, "API", String.valueOf(artifacts.size()) + " returned"}), new Object[0]);
        }
    }

    public void testAtsQuickSearchQueries(XResultData rd) {
        for (OseeProductionTestProvider provider : providers) {
            for (Map.Entry<String, QueryBuilderArtifact> entry : provider.getAtsQuickSearchQueries().entrySet()) {
                String title = entry.getKey();
                ElapsedTime time = new ElapsedTime(title);
                ResultSet artifacts = entry.getValue().getResults();
                boolean passed = true;
                Long ms = time.getTimeSpent();
                rd.logf(AHTML.addRowMultiColumnTable((String[])new String[]{ms.toString(), this.getPassFail(passed), title, "API", String.valueOf(artifacts.size()) + " returned"}), new Object[0]);
            }
        }
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Arrays.asList(AtsUserGroups.AtsAdmin);
    }
}

