/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.widget;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.notify.WorkflowEmailWizard;
import org.eclipse.osee.ats.ide.util.AtsUserLabelProvider;
import org.eclipse.osee.ats.ide.util.UserCheckTreeDialog;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.EmailGroup;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.validation.OseeValidator;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.AttributeWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XListViewer;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class XAtsUserListDam
extends XListViewer
implements AttributeWidget {
    private AbstractWorkflowArtifact awa;
    private AttributeTypeToken attributeType;
    private final Collection<AtsUser> selectedUsers = new LinkedList<AtsUser>();

    public XAtsUserListDam(String displayLabel) {
        super(displayLabel);
    }

    public Artifact getStored() {
        Object obj = this.awa.getSoleAttributeValue((AttributeTypeId)this.attributeType, null);
        if (obj instanceof Integer) {
            return ArtifactQuery.getArtifactFromId((long)((Integer)obj).intValue(), (BranchId)this.awa.getBranch());
        }
        if (obj instanceof Artifact) {
            return (Artifact)obj;
        }
        return null;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        this.setLabelProvider((ILabelProvider)new AtsUserLabelProvider());
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        super.createControls(parent, horizontalSpan);
        this.setVerticalLabel(true);
        this.selectedUsers.addAll(this.getStoredAtsUsers());
        this.setInput(this.selectedUsers);
        GridData gd = new GridData(4, 0, false, false);
        gd.horizontalSpan = 2;
        gd.heightHint = 60;
        this.getTable().setLayoutData((Object)gd);
    }

    private Collection<AtsUser> getStoredAtsUsers() {
        LinkedList<AtsUser> users = new LinkedList<AtsUser>();
        for (String userId : this.awa.getAttributesToStringList((AttributeTypeId)this.attributeType)) {
            AtsUser user = AtsApiService.get().getUserService().getUserByUserId(userId);
            if (user == null || AtsCoreUsers.isSystemUser((AtsUser)user)) continue;
            users.add(user);
        }
        return users;
    }

    private Collection<AtsUser> getSelectedUsers() {
        return this.selectedUsers;
    }

    protected void createControlsAfterLabel(Composite parent, int horizontalSpan) {
        Composite mComp = new Composite(parent, 0x800000);
        GridData gd = new GridData(4, 0, false, false);
        gd.horizontalSpan = 2;
        mComp.setLayoutData((Object)gd);
        mComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
        mComp.setBackgroundMode(2);
        Button modifyList = new Button(mComp, 8);
        modifyList.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.EDIT));
        modifyList.setToolTipText("Select to modify");
        modifyList.setLayoutData((Object)new GridData(16384, 0, false, false));
        modifyList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XAtsUserListDam.this.handleModifyList();
            }
        });
        Button emailSelected = new Button(mComp, 8);
        emailSelected.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.EMAIL));
        emailSelected.setToolTipText("Email");
        emailSelected.setLayoutData((Object)new GridData(16384, 0, false, false));
        emailSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WorkflowEmailWizard wizard = new WorkflowEmailWizard(XAtsUserListDam.this.awa);
                    LinkedList<String> emails = new LinkedList<String>();
                    for (AtsUser user : XAtsUserListDam.this.isDirty().isTrue() ? XAtsUserListDam.this.getSelectedUsers() : XAtsUserListDam.this.getStoredAtsUsers()) {
                        emails.add(user.getEmail());
                    }
                    if (!emails.isEmpty()) {
                        wizard.getEmailableGroups().add(new EmailGroup(XAtsUserListDam.this.getLabel(), emails));
                    }
                    WizardDialog dialog = new WizardDialog(Displays.getActiveShell(), (IWizard)wizard);
                    dialog.create();
                    dialog.open();
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    private void handleModifyList() {
        try {
            UserCheckTreeDialog uld = new UserCheckTreeDialog("Select User(s)", "Select Users.", AtsApiService.get().getUserService().getUsers(Active.Active));
            Collection<AtsUser> atsUsers = this.getStoredAtsUsers();
            if (!atsUsers.isEmpty()) {
                uld.setInitialSelections(atsUsers);
            }
            if (uld.open() == 0) {
                this.selectedUsers.clear();
                Object[] objectArray = uld.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    User user = (User)obj;
                    AtsUser atsUser = AtsApiService.get().getUserService().getUserById((ArtifactId)user);
                    if (!AtsCoreUsers.isUnAssignedUser((AtsUser)atsUser)) {
                        this.selectedUsers.add(atsUser);
                    }
                    ++n2;
                }
                this.listViewer.setInput(this.selectedUsers);
                this.notifyXModifiedListeners();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void saveToArtifact() {
        LinkedList<String> userIds = new LinkedList<String>();
        for (AtsUser user : this.getSelectedUsers()) {
            if (AtsCoreUsers.isUnAssignedUser((AtsUser)user)) continue;
            userIds.add(user.getUserId());
        }
        if (userIds.isEmpty()) {
            this.awa.deleteAttributes((AttributeTypeId)this.attributeType);
        } else {
            this.awa.setAttributeValues((AttributeTypeId)this.attributeType, userIds);
        }
    }

    public void revert() {
        this.selectedUsers.clear();
        this.selectedUsers.addAll(this.getStoredAtsUsers());
        this.listViewer.setInput(this.selectedUsers);
    }

    public Result isDirty() {
        Collection<AtsUser> storedAtsUsers;
        Collection<AtsUser> selectedUsers2;
        Result result = Result.FalseResult;
        if (this.isEditable() && !Collections.isEqual(selectedUsers2 = this.getSelectedUsers(), storedAtsUsers = this.getStoredAtsUsers())) {
            result = new Result(true, this.attributeType + " is dirty");
        }
        return result;
    }

    public Artifact getArtifact() {
        return this.awa;
    }

    public void refresh() {
        Artifact storedArt = this.getStored();
        if (storedArt != null) {
            this.setSelected(storedArt);
        }
    }

    public void setAttributeType(Artifact artifact, AttributeTypeToken attributeType) {
        this.awa = (AbstractWorkflowArtifact)artifact;
        this.attributeType = attributeType;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    public IStatus isValid() {
        IStatus status = super.isValid();
        if (status.isOK()) {
            try {
                XResultData rd;
                if (this.getArtifact() != null && this.getAttributeType() != null && (rd = OseeValidator.getInstance().validate(10, this.getArtifact(), this.getAttributeType(), this.getSelectedUsers())).isErrors()) {
                    status = new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), rd.toString());
                }
            }
            catch (OseeCoreException ex) {
                status = new Status(4, "org.eclipse.osee.ats.ide", "Error getting Artifact", (Throwable)ex);
            }
        }
        return status;
    }
}

