/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.section.goal;

import java.util.Collection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.goal.AbstractWebExportAction;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredListDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.graphics.Image;

public class SelectWebExportCustomizationAction
extends AbstractWebExportAction {
    public SelectWebExportCustomizationAction(GoalArtifact goalArt, WorkflowEditor editor) {
        super("Select Web Export Customization", goalArt, editor, (OseeImage)AtsImage.CUSTOMIZE);
    }

    @Override
    public void runWithException() {
        Collection customizations = AtsApiService.get().getStoreService().getCustomizations("GoalXViewer");
        FilteredListDialog dialog = new FilteredListDialog("Select Customization", "Select Customization", (ILabelProvider)new CustomizeLabelProvider());
        dialog.setInput(customizations);
        if (dialog.open() == 0 && dialog.getSelected() != null) {
            CustomizeData custData = (CustomizeData)dialog.getSelected();
            IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getText());
            changes.setSoleAttributeValue((IAtsObject)this.goalArt, (AttributeTypeToken)AtsAttributeTypes.WorldResultsCustId, (Object)custData.getGuid());
            changes.executeIfNeeded();
            AWorkbench.popup((String)this.getText(), (String)"Customization Set to [%s]", (Object[])new Object[]{custData.getName()});
        }
    }

    private class CustomizeLabelProvider
    implements ILabelProvider {
        private CustomizeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return ImageManager.getImage((OseeImage)AtsImage.CUSTOMIZE);
        }

        public String getText(Object element) {
            return ((CustomizeData)element).getName();
        }
    }
}

