/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.section;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.core.workflow.log.AtsLogUtility;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeStateNotesHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.DuplicateWidgetUpdateResolver;
import org.eclipse.osee.ats.ide.editor.tab.workflow.widget.ReviewInfoXWidget;
import org.eclipse.osee.ats.ide.editor.tab.workflow.widget.TaskInfoXWidget;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.util.XCancellationReasonTextWidget;
import org.eclipse.osee.ats.ide.workdef.StateXWidgetPage;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.hooks.IAtsWorkItemHookIde;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.parts.AttributeFormPart;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactStoredWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XLabelValue;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidgetUtility;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WfeWorkflowSection
extends SectionPart {
    protected final AbstractWorkflowArtifact sma;
    private final StateXWidgetPage statePage;
    private final boolean isEditable;
    private Composite mainComp;
    private final List<XWidget> allXWidgets = new ArrayList<XWidget>();
    private boolean sectionCreated = false;
    private Section section;
    private final WorkflowEditor editor;
    private WfeStateNotesHeader stateNotesHeader;
    final WfeWorkflowSection fSection = this;
    final XModifiedListener xModListener = new XModifiedListener(){

        public void widgetModified(XWidget xWidget) {
            try {
                if (WfeWorkflowSection.this.sma.isDeleted()) {
                    return;
                }
                for (IAtsWorkItemHookIde item : AtsApiService.get().getWorkItemServiceIde().getWorkItemHooksIde()) {
                    try {
                        item.widgetModified(xWidget, (FormToolkit)WfeWorkflowSection.this.editor.getToolkit(), WfeWorkflowSection.this.sma.getStateDefinition(), WfeWorkflowSection.this.sma, WfeWorkflowSection.this.isEditable);
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
                DuplicateWidgetUpdateResolver.updateDuplicateWidgets(WfeWorkflowSection.this.getManagedForm(), WfeWorkflowSection.this.sma, xWidget);
                WfeWorkflowSection.this.editor.onDirtied();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    };
    private ReviewInfoXWidget reviewInfoXWidget;
    private TaskInfoXWidget taskInfoXWidget;

    public WfeWorkflowSection(Composite parent, int style, StateXWidgetPage page, AbstractWorkflowArtifact sma, WorkflowEditor editor) {
        super(parent, (FormToolkit)editor.getToolkit(), style | 2 | 0x100);
        this.statePage = page;
        this.sma = sma;
        this.editor = editor;
        this.isEditable = AtsApiService.get().getAtsAccessService().isWorkflowEditable((IAtsWorkItem)sma);
    }

    public boolean isCurrentState() {
        boolean isCurrent = this.sma.isInState(new IStateToken[]{this.statePage});
        return isCurrent;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.section = this.getSection();
        try {
            this.refreshStateTitle();
            this.section.setLayoutData((Object)new GridData(768));
            boolean isCurrentSectionExpanded = this.isCurrentSectionExpanded(this.statePage);
            this.createSection(this.section);
            this.section.layout();
            this.section.setExpanded(isCurrentSectionExpanded);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void expand() {
        this.section.setExpanded(true);
        this.createSection(this.section);
    }

    private void refreshStateTitle() {
        String currentStateTitle = WfeWorkflowSection.getCurrentStateTitle(this.sma, this.statePage.getName(), this.isCurrentState(), this.statePage.isCancelled());
        this.section.setText(currentStateTitle);
        if (this.sma.isInState(new IStateToken[]{this.statePage})) {
            this.section.setTitleBarForeground(Displays.getSystemColor((int)6));
        } else {
            this.section.setTitleBarForeground(Displays.getSystemColor((int)10));
            this.section.setBackground(Displays.getSystemColor((int)1));
        }
    }

    public boolean isCurrentSectionExpanded(IStateToken state) {
        return this.sma.isInState(new IStateToken[]{state});
    }

    private synchronized void createSection(Section section) {
        if (this.sectionCreated) {
            return;
        }
        this.mainComp = this.editor.getToolkit().createClientContainer(section, 2);
        this.mainComp.setLayoutData((Object)new GridData(1810));
        this.mainComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        this.mainComp.layout();
        this.stateNotesHeader = new WfeStateNotesHeader(this.mainComp, 0, this.editor.getWorkItem(), this.statePage.getName(), this.editor);
        Composite workComp = this.createWorkArea(this.mainComp, this.statePage, this.editor.getToolkit());
        GridData gridData = new GridData(1810);
        gridData.widthHint = 400;
        workComp.setLayoutData((Object)gridData);
        this.sectionCreated = true;
    }

    protected Composite createWorkArea(Composite comp, StateXWidgetPage statePage, XFormToolkit toolkit) {
        statePage.generateLayoutDatas();
        if (statePage.getStateDefinition().getDescription() != null) {
            Composite labelComp = toolkit.createContainer(comp, 1);
            labelComp.setLayoutData((Object)new GridData(1808));
            labelComp.setLayout((Layout)ALayout.getZeroMarginLayout());
            Label descLabel = this.editor.getToolkit().createLabel(labelComp, " State Description: " + statePage.getStateDefinition().getDescription());
            GridData gd = new GridData(4, 0, true, false);
            descLabel.setLayoutData((Object)gd);
        }
        Composite workComp = toolkit.createContainer(comp, 1);
        workComp.setLayoutData((Object)new GridData(1810));
        for (IAtsWorkItemHookIde item : AtsApiService.get().getWorkItemServiceIde().getWorkItemHooksIde()) {
            for (XWidget xWidget : item.getDynamicXWidgetsPreBody(this.sma, statePage.getName())) {
                xWidget.createWidgets(workComp, 2);
                this.allXWidgets.add(xWidget);
                this.allXWidgets.addAll(xWidget.getChildrenXWidgets());
            }
        }
        if (statePage.isCompletedOrCancelled() && statePage.getStateDefinition().getLayoutItems().isEmpty()) {
            Composite completeComp = new Composite(workComp, 0);
            GridLayout layout = new GridLayout(1, false);
            completeComp.setLayout((Layout)layout);
            completeComp.setLayoutData((Object)new GridData(768));
            if (statePage.isCancelled()) {
                this.createCancelledPageWidgets(completeComp);
            } else if (statePage.isCompleted()) {
                this.createCompletedPageWidgets(completeComp);
            }
        }
        this.createSectionBody(statePage, workComp);
        for (IAtsWorkItemHookIde item : AtsApiService.get().getWorkItemServiceIde().getWorkItemHooksIde()) {
            for (XWidget xWidget : item.getDynamicXWidgetsPostBody(this.sma, statePage.getName())) {
                xWidget.createWidgets(workComp, 2);
                this.allXWidgets.add(xWidget);
                this.allXWidgets.addAll(xWidget.getChildrenXWidgets());
            }
        }
        this.createTaskFooter(workComp, statePage);
        this.createReviewFooter(workComp, statePage);
        XWidgetUtility.setLabelFontsBold(this.allXWidgets);
        this.adaptWidgets();
        this.computeTextSizesAndReflow();
        return workComp;
    }

    private void adaptWidgets() {
        for (XWidget widget : this.allXWidgets) {
            widget.adaptControls((FormToolkit)this.editor.getToolkit());
        }
    }

    private void createSectionBody(StateXWidgetPage statePage, Composite workComp) {
        SwtXWidgetRenderer dynamicXWidgetLayout = statePage.createBody(this.getManagedForm(), workComp, this.sma, this.xModListener, this.isEditable);
        for (XWidget xWidget : dynamicXWidgetLayout.getXWidgets()) {
            this.addAndCheckChildren(xWidget);
        }
    }

    private void addAndCheckChildren(XWidget xWidget) {
        this.allXWidgets.add(xWidget);
        xWidget.addXModifiedListener(this.xModListener);
        for (XWidget childWidget : xWidget.getChildrenXWidgets()) {
            this.addAndCheckChildren(childWidget);
        }
    }

    public void computeTextSizesAndReflow() {
        for (XWidget widget : this.allXWidgets) {
            if (!(widget instanceof XText)) continue;
            AttributeFormPart.computeXTextSize((XText)((XText)widget));
        }
        this.getManagedForm().reflow(true);
    }

    private void createCancelledPageWidgets(Composite parent) {
        Object xWidget = null;
        xWidget = new XLabelValue("Cancelled from State", this.sma.getCancelledFromState());
        xWidget.createWidgets(parent, 1);
        this.allXWidgets.add((XWidget)xWidget);
        xWidget = new XCancellationReasonTextWidget(this.sma, this.editor);
        xWidget.addXModifiedListener(this.xModListener);
        xWidget.createWidgets(parent, 1);
        this.allXWidgets.add((XWidget)xWidget);
    }

    private void createCompletedPageWidgets(Composite parent) {
        XLabelValue xWidget = null;
        xWidget = new XLabelValue("Completed from State", this.sma.getCompletedFromState());
        xWidget.createWidgets(parent, 1);
        this.allXWidgets.add((XWidget)xWidget);
    }

    private void createReviewFooter(Composite parent, IStateToken forState) {
        if (this.isShowReviewInfo() && this.sma.isTeamWorkflow()) {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            comp.setLayout((Layout)layout);
            comp.setLayoutData((Object)new GridData(768));
            this.reviewInfoXWidget = new ReviewInfoXWidget(this, this.editor.getToolkit(), (TeamWorkFlowArtifact)this.sma, forState, comp, 1);
            this.allXWidgets.add((XWidget)this.reviewInfoXWidget);
        }
    }

    private void createTaskFooter(Composite parent, IStateToken state) {
        if (this.sma instanceof TeamWorkFlowArtifact) {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(6, false);
            comp.setLayout((Layout)layout);
            comp.setLayoutData((Object)new GridData(768));
            this.taskInfoXWidget = new TaskInfoXWidget(this.getManagedForm(), (TeamWorkFlowArtifact)this.sma, state, comp, 2);
            this.allXWidgets.add((XWidget)this.taskInfoXWidget);
        }
    }

    protected boolean isShowReviewInfo() {
        return this.sma.isTeamWorkflow();
    }

    public Result isXWidgetSavable() {
        for (XWidget widget : this.allXWidgets) {
            IStatus status;
            if (!(widget instanceof ArtifactStoredWidget) || (status = widget.isValid()).isOK()) continue;
            return new Result(false, status.getMessage());
        }
        return Result.TrueResult;
    }

    public String toString() {
        return this.statePage + " for " + (Object)((Object)this.getSma());
    }

    public Result isXWidgetDirty(XResultData rd) {
        for (XWidget widget : this.allXWidgets) {
            Result result;
            ArtifactStoredWidget artifactStoredWidget;
            if (!(widget instanceof ArtifactStoredWidget) || (artifactStoredWidget = (ArtifactStoredWidget)widget).getArtifact() == null || !(result = artifactStoredWidget.isDirty()).isTrue()) continue;
            rd.errorf("Widget [%s] is dirty\n", new Object[]{widget.toString()});
        }
        return Result.FalseResult;
    }

    public void getDirtyIArtifactWidgets(List<ArtifactStoredWidget> widgets) {
        for (XWidget widget : this.allXWidgets) {
            ArtifactStoredWidget artifactStoredWidget;
            if (!(widget instanceof ArtifactStoredWidget) || !(artifactStoredWidget = (ArtifactStoredWidget)widget).isDirty().isTrue()) continue;
            widgets.add(artifactStoredWidget);
        }
    }

    protected static String getCurrentStateTitle(IAtsWorkItem workItem, String statePageName, boolean isCurrentState, boolean isCancelledState) {
        StringBuffer sb = new StringBuffer(statePageName);
        AtsApiIde atsApi = AtsApiService.get();
        if (isCurrentState && !workItem.isCompleted() && !workItem.isCancelled()) {
            sb.append(" - Current State");
        }
        if (workItem.isCancelled() && isCancelledState && Strings.isValid((String)workItem.getCancelledReason())) {
            sb.append(" - Reason: ");
            sb.append(Strings.truncate((String)workItem.getCancelledReason(), (int)50, (boolean)true));
        }
        if (isCurrentState) {
            if (workItem.isCompleted()) {
                if (!workItem.getCurrentStateName().equals(StateType.Completed.toString())) {
                    sb.append(" (Completed)");
                }
                sb.append(" - ");
                sb.append(DateUtil.getMMDDYYHHMM((Date)workItem.getCompletedDate()));
                IAtsLogItem item = atsApi.getWorkItemService().getStateStartedData(workItem, statePageName);
                if (item != null) {
                    sb.append(" by ");
                    sb.append(AtsLogUtility.getUserName((String)item.getUserId(), (IAtsUserService)AtsApiService.get().getUserService()));
                }
            } else if (workItem.isCancelled()) {
                if (!workItem.getCurrentStateName().equals(StateType.Cancelled.toString())) {
                    sb.append(" (Cancelled)");
                }
                sb.append(" - ");
                sb.append(DateUtil.getMMDDYYHHMM((Date)workItem.getCancelledDate()));
                IAtsLogItem item = atsApi.getWorkItemService().getStateStartedData(workItem, statePageName);
                if (item != null) {
                    sb.append(" by ");
                    sb.append(AtsLogUtility.getUserName((String)item.getUserId(), (IAtsUserService)AtsApiService.get().getUserService()));
                }
            }
            if (workItem.getAssignees().size() > 0) {
                sb.append(" assigned to ");
                sb.append(workItem.getAssigneesStr(80));
            }
        } else {
            IAtsLogItem item = null;
            if (workItem.isCancelled() && workItem.getCancelledFromState().equals(statePageName)) {
                item = atsApi.getWorkItemService().getStateCancelledData(workItem, statePageName);
                sb.append(" - State Cancelled ");
            } else {
                item = atsApi.getWorkItemService().getStateCompletedData(workItem, statePageName);
                sb.append(" - State Completed ");
            }
            if (item != null) {
                sb.append(item.getDate("MM/dd/yyyy hh:mm a"));
                sb.append(" by ");
                sb.append(AtsLogUtility.getUserName((String)item.getUserId(), (IAtsUserService)AtsApiService.get().getUserService()));
            }
        }
        return sb.toString();
    }

    public void dispose() {
        for (XWidget xWidget : this.allXWidgets) {
            if (xWidget == null) continue;
            xWidget.dispose();
        }
        this.statePage.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        WfeWorkflowSection wfeWorkflowSection = this;
        synchronized (wfeWorkflowSection) {
            if (!Widgets.isAccessible((Widget)this.mainComp)) {
                return;
            }
        }
        super.refresh();
        try {
            wfeWorkflowSection = this;
            synchronized (wfeWorkflowSection) {
                if (Widgets.isAccessible((Widget)this.stateNotesHeader)) {
                    this.stateNotesHeader.refresh();
                }
            }
            for (XWidget xWidget : this.allXWidgets) {
                if (xWidget instanceof ArtifactStoredWidget) {
                    ((ArtifactStoredWidget)xWidget).refresh();
                    continue;
                }
                xWidget.refresh();
            }
            if (this.reviewInfoXWidget != null) {
                this.reviewInfoXWidget.reDisplay();
            }
            this.refreshStateTitle();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public AbstractWorkflowArtifact getSma() {
        return this.sma;
    }

    public StateXWidgetPage getPage() {
        return this.statePage;
    }

    public synchronized Composite getMainComp() {
        return this.mainComp;
    }

    public List<XWidget> getXWidgets(Class<?> clazz) {
        ArrayList<XWidget> widgets = new ArrayList<XWidget>();
        for (XWidget widget : this.allXWidgets) {
            if (!clazz.isInstance(widget)) continue;
            widgets.add(widget);
        }
        return widgets;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public StateXWidgetPage getStatePage() {
        return this.statePage;
    }

    public WorkflowEditor getEditor() {
        return this.editor;
    }
}

