/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.util.UserCheckTreeDialog;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.cr.sibling.base.XSiblingActionBar;
import org.eclipse.osee.ats.ide.workflow.hooks.IAtsWorkItemHookIde;
import org.eclipse.osee.ats.ide.workflow.transition.TransitionDataUi;
import org.eclipse.osee.ats.ide.workflow.transition.TransitionResultsUi;
import org.eclipse.osee.ats.ide.workflow.transition.TransitionToOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ListSelectionDialogNoSave;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeTransitionHeader
extends Composite {
    private final Label transitionAssigneesLabel;
    private final AbstractWorkflowArtifact workItem;
    private final WorkflowEditor editor;
    private StateDefinition userSelectedTransitionToState;
    private final boolean isEditable;
    private final Hyperlink transitionLabelLink;
    private final Hyperlink stateLabelLink;
    private Hyperlink createSiblingLink;

    public WfeTransitionHeader(Composite parent, final WorkflowEditor editor, final boolean isEditable) {
        super(parent, 0);
        boolean createSiblingWorkflowEnabled;
        this.editor = editor;
        this.isEditable = isEditable;
        this.workItem = editor.getWorkItem();
        this.setLayoutData(new GridData(768));
        GridLayout layout = new GridLayout(AtsApiService.get().getWorkItemService().isAllowSiblingCreation((IAtsWorkItem)this.workItem) ? 7 : 5, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        editor.getWorkFlowTab().getManagedForm().getToolkit().adapt((Composite)this);
        this.transitionLabelLink = editor.getToolkit().createHyperlink((Composite)this, "Transition", 0);
        this.transitionLabelLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (editor.isDirty()) {
                    editor.doSave(null);
                }
                WfeTransitionHeader.this.transitionLabelLink.setEnabled(false);
                WfeTransitionHeader.this.stateLabelLink.setEnabled(false);
                WfeTransitionHeader.this.handleTransitionButtonSelection();
            }
        });
        this.transitionLabelLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 3) {
                    WfeTransitionHeader.this.transitionLabelLink.setEnabled(false);
                    WfeTransitionHeader.this.stateLabelLink.setEnabled(false);
                    WfeTransitionHeader.this.handleTransitionButtonSelection(true);
                }
            }
        });
        this.transitionLabelLink.setFont(FontManager.getDefaultLabelFont());
        this.transitionLabelLink.setToolTipText("Select to transition workflow to the default (shown) state");
        Label transitionToLabel = editor.getToolkit().createLabel((Composite)this, "To");
        transitionToLabel.setLayoutData((Object)new GridData());
        String toStateName = this.getToState() == null ? "<not set>" : this.getToState().getName();
        this.stateLabelLink = editor.getToolkit().createHyperlink((Composite)this, toStateName, 0);
        this.stateLabelLink.setLayoutData((Object)new GridData(768));
        this.stateLabelLink.setToolTipText("Select to Transition to another state");
        this.stateLabelLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    StateDefinition selState = WfeTransitionHeader.handleChangeTransitionToState(WfeTransitionHeader.this.workItem, isEditable, WfeTransitionHeader.this.getToState());
                    if (selState != null) {
                        WfeTransitionHeader.this.userSelectedTransitionToState = selState;
                        WfeTransitionHeader.this.transitionLabelLink.setEnabled(false);
                        WfeTransitionHeader.this.stateLabelLink.setEnabled(false);
                        WfeTransitionHeader.this.handleTransitionButtonSelection();
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        });
        this.stateLabelLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                StateDefinition selState;
                if (e.button == 3 && (selState = WfeTransitionHeader.handleChangeTransitionToState(WfeTransitionHeader.this.workItem, isEditable, WfeTransitionHeader.this.getToState())) != null) {
                    WfeTransitionHeader.this.userSelectedTransitionToState = selState;
                    WfeTransitionHeader.this.transitionLabelLink.setEnabled(false);
                    WfeTransitionHeader.this.stateLabelLink.setEnabled(false);
                    WfeTransitionHeader.this.handleTransitionButtonSelection(true);
                }
            }
        });
        Hyperlink assigneesLabelLink = editor.getToolkit().createHyperlink((Composite)this, "Next State Assignee(s)", 0);
        assigneesLabelLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    WfeTransitionHeader.this.handleChangeTransitionAssignees(WfeTransitionHeader.this.workItem);
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
        this.transitionAssigneesLabel = editor.getToolkit().createLabel((Composite)this, Strings.truncate((String)this.workItem.getTransitionAssigneesStr(), (int)100, (boolean)true));
        this.transitionAssigneesLabel.setLayoutData((Object)new GridData(768));
        this.transitionAssigneesLabel.setToolTipText("Select to change assignee(s) upon transition to next state.");
        if (this.workItem.isTeamWorkflow() && (createSiblingWorkflowEnabled = AtsApiService.get().getWorkItemService().isAllowSiblingCreation((IAtsWorkItem)this.workItem))) {
            for (IAtsWorkItemHook hook : AtsApiService.get().getWorkItemService().getWorkItemHooks()) {
                if (!(hook instanceof IAtsWorkItemHookIde) || !((IAtsWorkItemHookIde)hook).createSiblingWidget(this.workItem, this, editor)) continue;
                return;
            }
            this.createSiblingLink = editor.getToolkit().createHyperlink((Composite)this, "Create Sibling Workflow(s)", 0);
            this.createSiblingLink.setLayoutData((Object)new GridData(768));
            this.createSiblingLink.setToolTipText("Create new Team Workflows off same Action");
            this.createSiblingLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        XSiblingActionBar.openCreateSiblingWorkflowBlam((IAtsTeamWorkflow)WfeTransitionHeader.this.workItem);
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            });
        }
    }

    public static StateDefinition handleChangeTransitionToState(AbstractWorkflowArtifact awa, boolean isEditable, StateDefinition toStateDef) {
        List states = AtsApiService.get().getWorkItemService().getAllToStates((IAtsWorkItem)awa);
        ListSelectionDialogNoSave dialog = new ListSelectionDialogNoSave(Collections.castAll((Collection)states), Displays.getActiveShell().getShell(), "Select Transition-To State", null, "Select the state to transition to.\n\nTransition will happen upon selection and Transition button.\n\nDouble-click will select, close and transition.", 2, new String[]{"Transition", "Cancel"}, 0, (IBaseLabelProvider)new StateListLabelProvider());
        if (dialog.open() == 0) {
            Object obj = dialog.getSelected();
            return (StateDefinition)obj;
        }
        return null;
    }

    public void handleTransitionButtonSelection() {
        this.handleTransitionButtonSelection(false);
    }

    public void handleTransitionButtonSelection(boolean debug) {
        StateDefinition toStateDef = this.getToState();
        if (toStateDef == null) {
            AWorkbench.popup((String)"Must select state to transition.");
            this.refresh();
            return;
        }
        if (this.editor.isDirty()) {
            this.editor.doSave(null);
        }
        this.editor.getWorkFlowTab().setLoading(true);
        WfeTransitionHeader.handleTransitionButtonSelection(this.workItem, this.isEditable, toStateDef, this.editor, this, debug);
    }

    public static void handleTransitionButtonSelection(AbstractWorkflowArtifact awa, boolean isEditable, StateDefinition toStateDef, final WorkflowEditor editor, final WfeTransitionHeader transitionHeader, boolean debug) {
        TransitionData transData = new TransitionData("Workflow Editor Transition", Arrays.asList(awa), toStateDef.getName(), awa.getTransitionAssignees(), null, null, new TransitionOption[]{TransitionOption.None});
        transData.setDebug(debug);
        TransitionDataUi.getCancellationReason(transData);
        TransitionDataUi.getTransitionBy(transData);
        final TransitionToOperation operation = new TransitionToOperation(transData);
        Operations.executeAsJob((IOperation)operation, (boolean)true, (int)20, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                TransitionResults results = operation.getResults();
                if (results != null) {
                    results.setAtsApi((AtsApi)AtsApiService.get());
                    if (results.isErrors()) {
                        TransitionResultsUi.reportDialog("Transition Failed", results);
                        AtsUtilClient.logExceptions(results);
                    }
                    if (results.isDebug()) {
                        XResultDataUI.report((XResultData)results.getTimeRd(), (String)"Transition Debug");
                    }
                }
                editor.getWorkFlowTab().setLoading(false);
                transitionHeader.refresh();
            }
        });
    }

    public StateDefinition getToState() {
        StateDefinition state = AtsApiService.get().getWorkItemService().getDefaultToState((IAtsWorkItem)this.workItem);
        if (this.userSelectedTransitionToState != null) {
            return this.userSelectedTransitionToState;
        }
        String transitionStateOverride = null;
        for (IAtsTransitionHook item : AtsApiService.get().getWorkItemService().getTransitionHooks()) {
            transitionStateOverride = item.getOverrideTransitionToStateName((IAtsWorkItem)this.editor.getWorkItem());
            if (transitionStateOverride != null) break;
        }
        if (transitionStateOverride != null) {
            if (AtsApiService.get().getWorkItemService().getDefaultToState((IAtsWorkItem)this.workItem).getName().equals(transitionStateOverride)) {
                state = AtsApiService.get().getWorkItemService().getDefaultToState((IAtsWorkItem)this.workItem);
            }
            for (StateDefinition toState : this.workItem.getStateDefinition().getToStates()) {
                if (!toState.getName().equals(transitionStateOverride)) continue;
                state = toState;
                break;
            }
        }
        return state;
    }

    public void refresh() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)WfeTransitionHeader.this.transitionAssigneesLabel)) {
                    StateDefinition toState = WfeTransitionHeader.this.userSelectedTransitionToState;
                    if (toState == null) {
                        toState = AtsApiService.get().getWorkItemService().getDefaultToState((IAtsWorkItem)WfeTransitionHeader.this.workItem);
                    }
                    if (toState == null) {
                        WfeTransitionHeader.this.stateLabelLink.setText("<Not Set>");
                    } else {
                        WfeTransitionHeader.this.stateLabelLink.setText(toState.getName());
                    }
                    WfeTransitionHeader.this.stateLabelLink.getParent().layout();
                    WfeTransitionHeader.this.transitionLabelLink.setEnabled(true);
                    WfeTransitionHeader.this.stateLabelLink.setEnabled(true);
                    WfeTransitionHeader.this.transitionAssigneesLabel.setText(WfeTransitionHeader.this.workItem.getTransitionAssigneesStr());
                    WfeTransitionHeader.this.transitionAssigneesLabel.getParent().layout();
                    WfeTransitionHeader.this.userSelectedTransitionToState = null;
                }
            }
        });
    }

    private void handleChangeTransitionAssignees(AbstractWorkflowArtifact aba) {
        this.userSelectedTransitionToState = this.getToState();
        if (this.userSelectedTransitionToState == null) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"No Transition State Selected");
            return;
        }
        if (this.userSelectedTransitionToState.isCompletedOrCancelled()) {
            AWorkbench.popup((String)"ERROR", (String)"No Assignees in Completed and Cancelled states");
            return;
        }
        UserCheckTreeDialog uld = new UserCheckTreeDialog();
        uld.setInitialSelections(aba.getTransitionAssignees());
        if (this.workItem.getParentTeamWorkflow() != null) {
            uld.setTeamMembers(AtsApiService.get().getTeamDefinitionService().getMembersAndLeads(this.workItem.getParentTeamWorkflow().getTeamDefinition()));
        }
        if (uld.open() != 0) {
            return;
        }
        Collection<AtsUser> users = uld.getUsersSelected();
        if (users.isEmpty()) {
            AWorkbench.popup((String)"ERROR", (String)"Must have at least one assignee");
            return;
        }
        this.workItem.setTransitionAssignees(users);
        this.refresh();
        this.editor.onDirtied();
    }

    public boolean isSelected() {
        return this.userSelectedTransitionToState != null;
    }

    public static class StateListLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof StateDefinition) {
                StateDefinition stateDef = (StateDefinition)element;
                Integer recPercent = ((StateDefinition)element).getRecommendedPercentComplete();
                if (recPercent != null && recPercent > 0) {
                    String stateStr = String.format("%s%s", stateDef.toString(), " - " + recPercent + "%");
                    return stateStr;
                }
                return stateDef.toString();
            }
            return element.toString();
        }
    }
}

