/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.Date;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeOriginatorHeader;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class WfeStateCreatedOrigHeader
extends Composite {
    private final IAtsWorkItem workItem;
    Label stateValueLabel;
    Label createdValueLabel;
    private final WfeOriginatorHeader originatorHeader;

    public WfeStateCreatedOrigHeader(Composite parent, int style, IAtsWorkItem workItem, WorkflowEditor editor) {
        super(parent, style);
        this.workItem = workItem;
        this.setLayoutData(new GridData(768));
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)3, (boolean)true));
        editor.getToolkit().adapt((Composite)this);
        try {
            this.stateValueLabel = FormsUtil.createLabelValue((XFormToolkit)editor.getToolkit(), (Composite)this, (String)"Current State: ", (String)"");
            this.createdValueLabel = FormsUtil.createLabelValue((XFormToolkit)editor.getToolkit(), (Composite)this, (String)"Created: ", (String)"");
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        this.originatorHeader = new WfeOriginatorHeader(this, 0, workItem, editor);
        this.originatorHeader.setBackground(parent.getParent().getParent().getBackground());
        this.refresh();
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.stateValueLabel)) {
            String isBlocked = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.BlockedReason, (Object)"");
            String isHold = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.HoldReason, (Object)"");
            if (Strings.isValid((String)isBlocked)) {
                this.stateValueLabel.setText(String.valueOf(this.workItem.getCurrentStateName()) + " (Blocked)");
                this.stateValueLabel.setForeground(Displays.getSystemColor((int)4));
            } else if (Strings.isValid((String)isHold)) {
                this.stateValueLabel.setText(String.valueOf(this.workItem.getCurrentStateName()) + " (Hold)");
                this.stateValueLabel.setForeground(Displays.getSystemColor((int)8));
            } else {
                this.stateValueLabel.setText(this.workItem.getCurrentStateName());
                this.stateValueLabel.setForeground(Displays.getSystemColor((int)2));
            }
            this.createdValueLabel.setText(DateUtil.getMMDDYYHHMM((Date)this.workItem.getCreatedDate()));
        }
        if (Widgets.isAccessible((Widget)this.originatorHeader)) {
            this.originatorHeader.refresh();
        }
    }
}

