/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workdef.model.WorkDefOption;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeActionableItemHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeActionableItemReviewHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeAnnotationsHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeAssigneesHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeAttachmentsComposite;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeBlockedWorkflowHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeCustomHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeDragAndDrop;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeHoldWorkflowHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeMetricsHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeRelatedComposite;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeStateCreatedOrigHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeStateNotesHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeTargetedVersionHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeTeamAndIdsHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeTitleHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeTransitionHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeWorkflowNotesHeader;
import org.eclipse.osee.ats.ide.editor.tab.workflow.section.DuplicateWidgetUpdateResolver;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workdef.StateXWidgetPage;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.hooks.IAtsWorkItemHookIde;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactStoredWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.HtmlDialog;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeHeaderComposite
extends Composite {
    private final WorkflowEditor editor;
    private final IAtsWorkItem workItem;
    private WfeRelatedComposite relatedComposite;
    private WfeActionableItemHeader actionableItemHeader;
    private WfeMetricsHeader metricsHeader;
    private final StateXWidgetPage currentStateXWidgetPage;
    private static Color LIGHT_GREY;
    private static WfeStateNotesHeader stateNotesHeader;
    private final IManagedForm managedForm;
    private WfeCustomHeader customHeader;
    private WfeTitleHeader titleHeader;
    private WfeTransitionHeader transitionHeader;
    private WfeStateCreatedOrigHeader stateHeader;
    private WfeTeamAndIdsHeader teamHeader;
    private WfeTargetedVersionHeader versionHeader;
    private WfeAssigneesHeader assigneeHeader;
    private WfeActionableItemReviewHeader aiReviewHeader;
    private WfeBlockedWorkflowHeader blockedWfHeader;
    private WfeHoldWorkflowHeader holdWfHeader;
    private WfeAttachmentsComposite attachmentsComposite;
    private WfeWorkflowNotesHeader workflowNotesHeader;
    final XModifiedListener xModListener = new XModifiedListener(){

        public void widgetModified(XWidget xWidget) {
            try {
                if (AtsApiService.get().getStoreService().isDeleted((IAtsObject)WfeHeaderComposite.this.workItem)) {
                    return;
                }
                for (IAtsWorkItemHookIde item : AtsApiService.get().getWorkItemServiceIde().getWorkItemHooksIde()) {
                    try {
                        boolean isEditable = !((Artifact)WfeHeaderComposite.this.workItem.getStoreObject()).isReadOnly() && ((AbstractWorkflowArtifact)WfeHeaderComposite.this.workItem.getStoreObject()).isAccessControlWrite();
                        item.widgetModified(xWidget, (FormToolkit)WfeHeaderComposite.this.editor.getToolkit(), WfeHeaderComposite.this.workItem.getStateDefinition(), (Artifact)WfeHeaderComposite.this.workItem, isEditable);
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
                DuplicateWidgetUpdateResolver.updateDuplicateWidgets(WfeHeaderComposite.this.managedForm, (AbstractWorkflowArtifact)WfeHeaderComposite.this.workItem, xWidget);
                WfeHeaderComposite.this.editor.onDirtied();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    };

    public WfeTransitionHeader getWfeTransitionHeader() {
        return this.transitionHeader;
    }

    public WfeHeaderComposite(Composite parent, int style, WorkflowEditor editor, StateXWidgetPage currentStateXWidgetPage, IManagedForm managedForm) {
        super(parent, style);
        this.editor = editor;
        this.currentStateXWidgetPage = currentStateXWidgetPage;
        this.managedForm = managedForm;
        this.workItem = editor.getWorkItem();
    }

    public void refresh() {
        if (this.titleHeader != null) {
            this.titleHeader.refresh();
        }
        if (this.stateHeader != null) {
            this.stateHeader.refresh();
        }
        if (this.teamHeader != null) {
            this.teamHeader.refresh();
        }
        if (this.versionHeader != null) {
            this.versionHeader.refresh();
        }
        if (this.assigneeHeader != null) {
            this.assigneeHeader.refresh();
        }
        if (this.actionableItemHeader != null) {
            this.actionableItemHeader.refresh();
        }
        if (this.metricsHeader != null) {
            this.metricsHeader.refresh();
        }
        if (stateNotesHeader != null) {
            stateNotesHeader.refresh();
        }
        if (this.workflowNotesHeader != null) {
            this.workflowNotesHeader.refresh();
        }
        if (this.relatedComposite != null) {
            this.relatedComposite.refresh();
        }
        if (this.attachmentsComposite != null) {
            this.attachmentsComposite.refresh();
        }
        if (this.transitionHeader != null) {
            this.transitionHeader.refresh();
        }
        if (this.blockedWfHeader != null) {
            this.blockedWfHeader.refresh();
        }
        if (this.holdWfHeader != null) {
            this.holdWfHeader.refresh();
        }
        if (this.aiReviewHeader != null) {
            this.aiReviewHeader.refresh();
        }
        if (this.customHeader != null) {
            this.customHeader.refresh();
        }
    }

    public void create() {
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        this.setLayoutData(gd);
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        try {
            new WfeAnnotationsHeader(this, 0, this.workItem, this.editor);
            this.titleHeader = new WfeTitleHeader(this, 0, this.workItem, this.editor, this.xModListener);
            this.stateHeader = new WfeStateCreatedOrigHeader(this, 0, this.workItem, this.editor);
            this.teamHeader = new WfeTeamAndIdsHeader(this, 0, this.workItem, this.editor);
            this.createTargetVersionAndAssigneeHeader(this, this.currentStateXWidgetPage, this.editor.getToolkit());
            this.createLatestHeader(this, this.editor.getToolkit());
            if (this.workItem.isTeamWorkflow()) {
                this.actionableItemHeader = new WfeActionableItemHeader(this, this.editor.getToolkit(), this.workItem, this.editor);
            }
            if (this.workItem.getWorkDefinition().getHeaderDef().isShowMetricsHeader()) {
                this.metricsHeader = new WfeMetricsHeader(this, this.editor.getToolkit(), this.workItem, this.editor, this.managedForm);
            }
            int numColumns = 4;
            WfeHeaderComposite.createWorkDefHeader(this, this.editor.getToolkit(), this.workItem, numColumns);
            this.createBlockedHoldHeader(this, this.editor.getToolkit());
            this.customHeader = this.createCustomHeader(this, this.editor.getToolkit(), this.workItem, this.editor, this.managedForm);
            this.createWorkflowNotesHeader(this, this.editor.getToolkit(), numColumns);
            this.createStateNotesHeader(this, this.workItem, this.editor.getToolkit(), numColumns, null, this.editor);
            this.relatedComposite = new WfeRelatedComposite(this, 0, this.editor);
            this.relatedComposite.create();
            this.attachmentsComposite = new WfeAttachmentsComposite(this, 0, this.editor);
            this.attachmentsComposite.create();
            if (WfeActionableItemReviewHeader.isApplicable(this.workItem)) {
                this.aiReviewHeader = new WfeActionableItemReviewHeader(this, this.editor.getToolkit(), (AbstractReviewArtifact)this.workItem, this.editor);
            }
            boolean isEditable = !((Artifact)this.workItem.getStoreObject()).isReadOnly() && ((AbstractWorkflowArtifact)this.workItem.getStoreObject()).isAccessControlWrite();
            this.transitionHeader = new WfeTransitionHeader(this, this.editor, isEditable);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createBlockedHoldHeader(WfeHeaderComposite parent, XFormToolkit toolkit) {
        Composite comp = new Composite((Composite)parent, 0);
        GridData gridData = new GridData(768);
        comp.setLayoutData((Object)gridData);
        int numColumns = 4;
        comp.setLayout((Layout)ALayout.getZeroMarginLayout((int)numColumns, (boolean)false));
        toolkit.adapt(comp);
        this.blockedWfHeader = new WfeBlockedWorkflowHeader(comp, 0, this.workItem, this.editor);
        this.holdWfHeader = new WfeHoldWorkflowHeader(comp, 0, this.workItem, this.editor);
    }

    private WfeCustomHeader createCustomHeader(Composite comp, XFormToolkit toolkit, IAtsWorkItem workItem, WorkflowEditor editor, IManagedForm managedForm) {
        return new WfeCustomHeader(comp, 0, managedForm, workItem, editor);
    }

    public static void createWorkDefHeader(Composite comp, XFormToolkit toolkit, IAtsWorkItem workItem, int horizontalSpan) {
        Composite headerComp = new Composite(comp, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        headerComp.setLayoutData((Object)gridData);
        int numColumns = 5;
        headerComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)numColumns, (boolean)false));
        toolkit.adapt(headerComp);
        WorkDefinition workDef = workItem.getWorkDefinition();
        Label label = FormsUtil.createLabelValue((XFormToolkit)toolkit, (Composite)headerComp, (String)"Work Definition: ", (String)workDef.getName());
        label.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                IWorkbenchPage page = AWorkbench.getActivePage();
                try {
                    page.showView("org.eclipse.ui.views.ContentOutline", null, 1);
                }
                catch (PartInitException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
        Label dragDropLabel = new Label(headerComp, 0);
        dragDropLabel.setText("Drag/Drop Related Here: ");
        FormsUtil.setLabelFonts((Control)dragDropLabel, (Font)FontManager.getDefaultLabelFont());
        dragDropLabel.setLayoutData((Object)new GridData());
        toolkit.adapt((Control)dragDropLabel, true, true);
        Label dragDropBox = new Label(headerComp, 2048);
        new WfeDragAndDrop((Control)dragDropBox, (AbstractWorkflowArtifact)workItem.getStoreObject(), "org.eclipse.osee.ats.ide.editor.WorkflowEditor");
        dragDropBox.setText("                             ");
        dragDropBox.setLayoutData((Object)new GridData(768));
        toolkit.adapt((Control)dragDropBox, true, true);
        dragDropBox.setBackground(WfeHeaderComposite.getLightGreyColor());
    }

    public void createWorkflowNotesHeader(Composite comp, XFormToolkit toolkit, int horizontalSpan) {
        this.workflowNotesHeader = new WfeWorkflowNotesHeader(comp, 0, this.workItem, null, this.editor);
    }

    public void createStateNotesHeader(Composite comp, IAtsWorkItem workItem, XFormToolkit toolkit, int horizontalSpan, String forStateName, WorkflowEditor editor) {
        stateNotesHeader = new WfeStateNotesHeader(comp, 0, workItem, null, editor);
    }

    private void createLatestHeader(Composite comp, XFormToolkit toolkit) {
        if (AtsApiService.get().getStoreService().isHistorical((IAtsObject)this.workItem)) {
            Label label = toolkit.createLabel(comp, "This is a historical version of this " + this.workItem.getArtifactTypeName() + " and can not be edited; Select \"Open Latest\" to view/edit latest version.");
            label.setForeground(Displays.getSystemColor((int)3));
        }
    }

    private void createTargetVersionAndAssigneeHeader(Composite parent, StateXWidgetPage page, XFormToolkit toolkit) {
        boolean isShowTargetedVersion = this.isShowTargetedVersion();
        boolean isCurrentNonCompleteCanceledState = page.isCurrentNonCompleteCancelledState((AbstractWorkflowArtifact)this.workItem.getStoreObject());
        if (!isShowTargetedVersion && !isCurrentNonCompleteCanceledState) {
            return;
        }
        Composite comp = toolkit.createContainer(parent, 6);
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)ALayout.getZeroMarginLayout((int)6, (boolean)false));
        if (isShowTargetedVersion) {
            this.versionHeader = new WfeTargetedVersionHeader(comp, 0, (IAtsTeamWorkflow)this.workItem, this.editor);
            toolkit.createLabel(comp, "    ");
        }
        if (isCurrentNonCompleteCanceledState) {
            boolean editable = this.isAssigneeEditable((AbstractWorkflowArtifact)this.workItem.getStoreObject());
            this.assigneeHeader = new WfeAssigneesHeader(comp, 0, this.workItem, editable, this.editor);
        }
    }

    public boolean isAssigneeEditable(AbstractWorkflowArtifact awa) {
        return !awa.isCompletedOrCancelled() && !awa.isReadOnly() && awa.isAccessControlWrite();
    }

    public boolean isShowTargetedVersion() {
        if (!this.workItem.isTeamWorkflow()) {
            return false;
        }
        if (this.workItem.getWorkDefinition().hasOption(WorkDefOption.NoTargetedVersion)) {
            return false;
        }
        return AtsApiService.get().getVersionService().isTeamUsesVersions(((TeamWorkFlowArtifact)this.workItem).getTeamDefinition());
    }

    private static Color getLightGreyColor() {
        if (LIGHT_GREY == null) {
            LIGHT_GREY = Displays.getColor((int)240, (int)240, (int)240);
        }
        return LIGHT_GREY;
    }

    public void dispose() {
        super.dispose();
        if (this.customHeader != null) {
            this.customHeader.dispose();
        }
        if (this.actionableItemHeader != null) {
            this.actionableItemHeader.dispose();
        }
        if (this.metricsHeader != null) {
            this.metricsHeader.dispose();
        }
    }

    public XResultData isXWidgetDirty(XResultData rd) {
        if (this.titleHeader != null) {
            this.titleHeader.isXWidgetDirty(rd);
        }
        if (this.customHeader != null) {
            this.customHeader.isXWidgetDirty(rd);
        }
        return rd;
    }

    public void getDirtyIArtifactWidgets(List<ArtifactStoredWidget> artWidgets) {
        if (this.titleHeader != null) {
            this.titleHeader.getDirtyIArtifactWidgets(artWidgets);
        }
        if (this.customHeader != null) {
            this.customHeader.getDirtyIArtifactWidgets(artWidgets);
        }
    }

    public Result isXWidgetSavable() {
        Result result;
        if (this.titleHeader != null && (result = this.titleHeader.isXWidgetSavable()).isTrue()) {
            return result;
        }
        if (this.customHeader != null) {
            return this.customHeader.isXWidgetSavable();
        }
        return Result.FalseResult;
    }

    public Collection<XWidget> getXWidgets(ArrayList<XWidget> widgets) {
        this.titleHeader.getXWidgets(widgets);
        this.relatedComposite.getXWidgets(widgets);
        this.customHeader.getXWidgets(widgets);
        return widgets;
    }

    public static void createLabelOrHyperlink(Composite comp, XFormToolkit toolkit, int horizontalSpan, final String str) {
        if (str.length() > 150) {
            Hyperlink label = toolkit.createHyperlink(comp, String.valueOf(Strings.truncate((String)str, (int)150)) + "...", 0);
            label.setToolTipText("click to view all");
            label.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    new HtmlDialog("Note", null, str).open();
                }
            });
            GridData gd = new GridData(768);
            gd.horizontalSpan = horizontalSpan;
            label.setLayoutData((Object)gd);
        } else {
            Label label = toolkit.createLabel(comp, str);
            GridData gd = new GridData(768);
            gd.horizontalSpan = horizontalSpan;
            label.setLayoutData((Object)gd);
        }
    }
}

