/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.bit.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactData;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactState;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitViewer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ListSelectionDialogNoSave;
import org.eclipse.osee.framework.ui.swt.Displays;

public class HandleBitStateChange {
    protected final IAtsTeamWorkflow crTeamWf;
    protected final AtsApi atsApi;
    private final XBitViewer xBitViewer;

    public HandleBitStateChange(IAtsTeamWorkflow crTeamWf, XBitViewer xBitViewer, AtsApi atsApi) {
        this.crTeamWf = crTeamWf;
        this.xBitViewer = xBitViewer;
        this.atsApi = atsApi;
    }

    public void handleMultiEdit() {
        List<BuildImpactData> bids = this.xBitViewer.getSelectedBuildImpactDatas();
        if (bids.isEmpty()) {
            AWorkbench.popup((String)"Select one or more Build Impact Items");
            return;
        }
        List<String> states = this.getStates();
        ListSelectionDialogNoSave dialog = this.getListSelectionDialog(states);
        if (dialog.open() == 0) {
            String newState = (String)dialog.getSelected();
            IAtsChangeSet changes = this.atsApi.createChangeSet("Update BID State");
            for (BuildImpactData bid : bids) {
                Artifact art = (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)bid.getBidArt());
                changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)AtsAttributeTypes.BitState, (Object)newState);
            }
            TransactionToken transaction = changes.executeIfNeeded();
            ((Artifact)this.crTeamWf).reloadAttributesAndRelations();
            this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_MODIFIED, Arrays.asList(this.crTeamWf), (TransactionId)transaction);
        }
    }

    public boolean handleChangeState(BuildImpactData bid) {
        List<String> states = this.getStates();
        states.remove(bid.getState());
        ListSelectionDialogNoSave dialog = this.getListSelectionDialog(states);
        if (dialog.open() == 0) {
            Artifact bidArt = (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)bid.getBidArt());
            bidArt.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.BitState, dialog.getSelected());
            TransactionId transactionId = bidArt.persist("Update BID State");
            ((Artifact)this.crTeamWf).reloadAttributesAndRelations();
            this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_MODIFIED, Arrays.asList(this.crTeamWf), transactionId);
            return true;
        }
        return false;
    }

    private ListSelectionDialogNoSave getListSelectionDialog(List<String> states) {
        ListSelectionDialogNoSave dialog = new ListSelectionDialogNoSave(Collections.castAll(states), Displays.getActiveShell().getShell(), "Select Transition-To State", null, "Select the state to transition to.\n\nTransition will happen upon selection and Transition button.\n\nDouble-click will select, close and transition.", 2, new String[]{"Transition", "Cancel"}, 0);
        return dialog;
    }

    private List<String> getStates() {
        ArrayList<String> states = new ArrayList<String>();
        for (String state : Arrays.asList(BuildImpactState.Open.name(), BuildImpactState.InWork.name(), BuildImpactState.Promoted.name(), BuildImpactState.Closed.name(), BuildImpactState.Deferred.name(), BuildImpactState.Cancelled.name())) {
            states.add(state);
        }
        return states;
    }
}

