/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.bit.action;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactData;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactDatas;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ProgramVersion;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ProgramVersionTreeDialog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class DeleteProgramVersionAction
extends Action {
    private final IAtsTeamWorkflow teamWf;
    private final AtsApi atsApi;

    public DeleteProgramVersionAction(IAtsTeamWorkflow teamWf) {
        this.teamWf = teamWf;
        this.atsApi = AtsApiService.get();
    }

    public void run() {
        ArrayList<ProgramVersion> pvers = new ArrayList<ProgramVersion>();
        final BuildImpactDatas currBids = this.atsApi.getServerEndpoints().getActionEndpoint().getBids(this.teamWf.getAtsId());
        for (BuildImpactData bid : currBids.getBuildImpacts()) {
            if (!bid.getTeamWfs().isEmpty()) continue;
            IAtsProgram program = this.atsApi.getProgramService().getProgramById((ArtifactId)bid.getProgram());
            IAtsVersion version = (IAtsVersion)this.atsApi.getConfigService().getConfigurations().getIdToVersion().get(bid.getBuild().getId());
            pvers.add(new ProgramVersion(program.getArtifactToken(), version, bid.getBidArt()));
        }
        final BuildImpactDatas newBids = new BuildImpactDatas();
        ProgramVersionTreeDialog dialog = new ProgramVersionTreeDialog("Select Program/Version", "Select Program/Version\n\nNOTE: Items with workflows can not be deleted and are not shown.", pvers);
        if (dialog.open() == 0) {
            newBids.setTeamWf(this.teamWf.getArtifactToken());
            for (ProgramVersion pVer : dialog.getChecked()) {
                BuildImpactData bid = new BuildImpactData();
                bid.setBids(newBids);
                bid.setBidArt(pVer.getProgVerArt());
                bid.setBuild(pVer.getVersion().getArtifactToken());
                bid.setProgram(pVer.getProgramTok());
                newBids.addBuildImpactData(bid);
            }
            Job deleteBidsJob = new Job("Delete BID(s)"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        BuildImpactDatas resultBids = DeleteProgramVersionAction.this.atsApi.getServerEndpoints().getActionEndpoint().deleteBids(DeleteProgramVersionAction.this.teamWf.getAtsId(), newBids);
                        if (resultBids.getResults().isErrors()) {
                            XResultDataUI.report((XResultData)currBids.getResults(), (String)"Error deleting BIDs");
                        } else {
                            ((Artifact)DeleteProgramVersionAction.this.teamWf).reloadAttributesAndRelations();
                            DeleteProgramVersionAction.this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_MODIFIED, Arrays.asList(DeleteProgramVersionAction.this.teamWf), currBids.getTransaction());
                        }
                    }
                    catch (Exception ex) {
                        XResultData rd = new XResultData();
                        rd.log(this.getName());
                        rd.logf("Exception Deleting BID(s) %s", new Object[]{Lib.exceptionToString((Exception)ex)});
                        ResultsEditor.open((String)("Error " + this.getName()), (XResultData)rd);
                    }
                    return Status.OK_STATUS;
                }
            };
            Jobs.startJob((Job)deleteBidsJob);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.X_RED);
    }

    public String getText() {
        return "Delete Impacted Program / Build";
    }

    public boolean isEnabled() {
        return this.teamWf.isInWork();
    }
}

