/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.bit.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.JaxTeamWorkflow;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BitUtil;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactData;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactDatas;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactState;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.bit.WfeBitTab;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitViewer;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ActionableItemTreeWithChildrenDialog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.TreeItem;

public class CreateBitTeamWorkflow
extends Action {
    private final IAtsTeamWorkflow teamWf;
    private final AtsApi atsApi;
    private final WorkflowEditor editor;

    public CreateBitTeamWorkflow(IAtsTeamWorkflow teamWf, WorkflowEditor editor) {
        this.teamWf = teamWf;
        this.editor = editor;
        this.atsApi = AtsApiService.get();
    }

    public void run() {
        WfeBitTab bitTab = this.editor.getBitTab();
        XBitViewer viewer = bitTab.getxViewer();
        TreeItem[] items = viewer.getTree().getSelection();
        if (items.length != 1) {
            AWorkbench.popup((String)"Must Select a Single Build Impact");
            return;
        }
        TreeItem item = items[0];
        Object selectedItem = item.getData();
        if (selectedItem instanceof BuildImpactData) {
            BuildImpactData bid = (BuildImpactData)selectedItem;
            if (!bid.getState().equals(BuildImpactState.InWork.name())) {
                AWorkbench.popup((String)"Build Impact selected must be in InWork state");
                return;
            }
            ArtifactToken progArt = bid.getProgram();
            IAtsProgram program = this.atsApi.getProgramService().getProgramById((ArtifactId)progArt);
            ArrayList<IAtsActionableItem> validAis = new ArrayList<IAtsActionableItem>();
            for (IAtsActionableItem ai : this.atsApi.getProgramService().getAis(program)) {
                if (ai.getTags() == null || !ai.getTags().contains(BitUtil.BIT_AI)) continue;
                validAis.add(ai);
            }
            IAtsTeamDefinition teamDef = this.atsApi.getProgramService().getTeamDefHoldingVersions(program);
            Objects.requireNonNull(teamDef, "teamDef can not be null");
            if (teamDef.getActionableItems() != null && !teamDef.getActionableItems().isEmpty()) {
                IAtsActionableItem ai = (IAtsActionableItem)teamDef.getActionableItems().iterator().next();
                validAis.remove(ai);
            }
            ActionableItemTreeWithChildrenDialog dialog = new ActionableItemTreeWithChildrenDialog(Active.Active, validAis);
            dialog.setAddIncludeAllCheckbox(false);
            if (dialog.open() == 0) {
                this.handleSelection(bid, dialog.getChecked(), bitTab, selectedItem);
            }
        } else {
            AWorkbench.popup((String)"Must Select a Single Build Impact");
            return;
        }
    }

    private void handleSelection(final BuildImpactData selBid, final Collection<IAtsActionableItem> aias, final WfeBitTab bitTab, Object selectedItem) {
        Job createSiblingJob = new Job("Creating Sibling Workflows"){

            protected IStatus run(IProgressMonitor monitor) {
                BuildImpactDatas bids = new BuildImpactDatas();
                bids.setTeamWf(CreateBitTeamWorkflow.this.teamWf.getArtifactToken());
                for (IAtsActionableItem ai : aias) {
                    BuildImpactData bid = new BuildImpactData();
                    bid.setBids(bids);
                    bid.setBidArt(selBid.getBidArt());
                    bid.setBuild(selBid.getBuild());
                    bid.setProgram(selBid.getProgram());
                    bid.setState(selBid.getState());
                    bids.addBuildImpactData(bid);
                    JaxTeamWorkflow jTeamWf = new JaxTeamWorkflow();
                    jTeamWf.setName(CreateBitTeamWorkflow.this.teamWf.getName());
                    jTeamWf.setNewAi(ai.getArtifactToken());
                    bitTab.creatingSibling(CreateBitTeamWorkflow.this.teamWf, jTeamWf, ai);
                    Version version = CreateBitTeamWorkflow.this.atsApi.getVersionService().getVersionById((ArtifactId)selBid.getBuild());
                    if (version != null) {
                        jTeamWf.setTargetVersion(version.getArtifactToken());
                    }
                    jTeamWf.setPriority((String)CreateBitTeamWorkflow.this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)CreateBitTeamWorkflow.this.teamWf, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)""));
                    bid.addTeamWorkflow(jTeamWf);
                }
                bids = CreateBitTeamWorkflow.this.atsApi.getServerEndpoints().getActionEndpoint().updateBids(CreateBitTeamWorkflow.this.teamWf.getAtsId(), bids);
                if (bids.getResults().isErrors()) {
                    XResultDataUI.report((XResultData)bids.getResults(), (String)"Error Creating Sibling Workflows");
                } else {
                    ((Artifact)CreateBitTeamWorkflow.this.teamWf).reloadAttributesAndRelations();
                    ((Artifact)CreateBitTeamWorkflow.this.teamWf.getParentAction()).reloadAttributesAndRelations();
                    CreateBitTeamWorkflow.this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_MODIFIED, Arrays.asList(CreateBitTeamWorkflow.this.teamWf), bids.getTransaction());
                }
                return Status.OK_STATUS;
            }
        };
        Operations.scheduleJob((Job)createSiblingJob, (boolean)true, (int)20, (IJobChangeListener)new CreateSiblingChangeAdapter(selectedItem, bitTab.getxViewer()));
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.WORKFLOW);
    }

    public String getText() {
        return "Create New Sibling Team Workflow(s)";
    }

    public boolean isEnabled() {
        return this.teamWf.isInWork();
    }

    private final class CreateSiblingChangeAdapter
    extends JobChangeAdapter {
        private final Object selectedItem;
        private final XBitViewer xBitViewer;

        public CreateSiblingChangeAdapter(Object selectedItem, XBitViewer xBitViewer) {
            this.selectedItem = selectedItem;
            this.xBitViewer = xBitViewer;
        }

        public void done(IJobChangeEvent event) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CreateSiblingChangeAdapter.this.xBitViewer.expandToLevel(CreateSiblingChangeAdapter.this.selectedItem, 2);
                }
            });
        }
    }
}

