/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.renderer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.CommandGroup;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.MenuCmdDef;
import org.eclipse.osee.framework.ui.skynet.render.DefaultArtifactRenderer;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class AtsWfeRenderer
extends DefaultArtifactRenderer {
    private static final String Option_WORKFLOW_EDITOR = "workflow.editor.option";

    public AtsWfeRenderer(RendererMap rendererOptions) {
        super(rendererOptions);
    }

    public AtsWfeRenderer() {
        this(null);
    }

    public void addMenuCommandDefinitions(ArrayList<MenuCmdDef> commands, Artifact artifact) {
        commands.add(new MenuCmdDef(CommandGroup.EDIT, PresentationType.SPECIALIZED_EDIT, "ATS Workflow Editor", ImageManager.create((OseeImage)AtsImage.ACTION), RendererOption.OPEN_OPTION.getKey(), Option_WORKFLOW_EDITOR));
    }

    public String getName() {
        return "ATS Workflow Editor";
    }

    public AtsWfeRenderer newInstance() {
        return new AtsWfeRenderer();
    }

    public AtsWfeRenderer newInstance(RendererMap rendererOptions) {
        return new AtsWfeRenderer(rendererOptions);
    }

    public int getApplicabilityRating(PresentationType presentationType, Artifact artifact, RendererMap rendererOptions) {
        if (!artifact.isHistorical() && !presentationType.matches(new PresentationType[]{PresentationType.GENERALIZED_EDIT, PresentationType.PRODUCE_ATTRIBUTE}) && artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsArtifact})) {
            if (Option_WORKFLOW_EDITOR.equals(rendererOptions.getRendererOptionValue(RendererOption.OPEN_OPTION)) && !UserManager.getBooleanSetting((String)UserManager.DOUBLE_CLICK_SETTING_KEY_EDIT) && !RendererManager.isDefaultArtifactEditor().booleanValue()) {
                return 60;
            }
            return 50;
        }
        return -1;
    }

    public void open(List<Artifact> artifacts, PresentationType presentationType) {
        for (Artifact artifact : artifacts) {
            AtsEditors.openATSAction((ArtifactToken)artifact, AtsOpenOption.OpenOneOrPopupSelect);
        }
    }
}

