/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.event;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactTopicEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.ui.swt.Displays;

public class WfeArtifactEventManager
implements IArtifactEventListener,
IArtifactTopicEventListener {
    static List<WorkflowEditor> editors = new CopyOnWriteArrayList<WorkflowEditor>();
    static WfeArtifactEventManager instance = new WfeArtifactEventManager();
    private final AtsApi atsApi;

    private WfeArtifactEventManager() {
        OseeEventManager.addListener((IEventListener)this);
        this.atsApi = AtsApiService.get();
    }

    public static void add(WorkflowEditor editor) {
        if (!editors.contains(editor)) {
            editors.add(editor);
        }
    }

    public static void remove(WorkflowEditor editor) {
        if (instance != null) {
            editors.remove(editor);
        }
    }

    public List<? extends IEventFilter> getEventFilters() {
        return AtsUtilClient.getAtsObjectEventFilters();
    }

    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return AtsUtilClient.getAtsTopicObjectEventFilters();
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        editors.removeIf(editor -> editor.isDisposed());
        try {
            if (!artifactEvent.isOnBranch((BranchId)AtsApiService.get().getAtsBranch())) {
                return;
            }
        }
        catch (OseeCoreException oseeCoreException) {
            return;
        }
        for (WorkflowEditor editor2 : editors) {
            try {
                this.safelyProcessHandler(artifactEvent, editor2);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)("Error processing event handler - " + editor2), (Throwable)ex);
            }
        }
    }

    public void handleArtifactTopicEvent(ArtifactTopicEvent artifactTopicEvent, Sender sender) {
        editors.removeIf(editor -> editor.isDisposed());
        try {
            if (!artifactTopicEvent.isOnBranch((BranchId)AtsApiService.get().getAtsBranch())) {
                return;
            }
        }
        catch (OseeCoreException oseeCoreException) {
            return;
        }
        for (WorkflowEditor editor2 : editors) {
            try {
                this.safelyProcessHandler(artifactTopicEvent, editor2);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)("Error processing event handler - " + editor2), (Throwable)ex);
            }
        }
    }

    private void safelyProcessHandler(ArtifactEvent artifactEvent, final WorkflowEditor editor) {
        AbstractWorkflowArtifact awa = editor.getWorkItem();
        if (artifactEvent.isDeletedPurged((Artifact)awa)) {
            editor.closeEditor();
            return;
        }
        if (artifactEvent.isHasEvent((Artifact)awa) || artifactEvent.isReloaded((Artifact)awa)) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    editor.refresh();
                }
            });
        } else if (awa.isTeamWorkflow()) {
            boolean refreshNeeded = false;
            for (IAtsTask task : this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)awa)) {
                if (!artifactEvent.isHasEvent((Artifact)task.getStoreObject())) continue;
                refreshNeeded = true;
                break;
            }
            if (!refreshNeeded) {
                for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews((IAtsTeamWorkflow)awa)) {
                    if (!artifactEvent.isHasEvent((Artifact)review.getStoreObject())) continue;
                    refreshNeeded = true;
                    break;
                }
            }
            if (refreshNeeded) {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        editor.refresh();
                    }
                });
            }
        }
    }

    private void safelyProcessHandler(ArtifactTopicEvent artifactTopicEvent, final WorkflowEditor editor) {
        AbstractWorkflowArtifact awa = editor.getWorkItem();
        if (artifactTopicEvent.isDeletedPurged((Artifact)awa)) {
            editor.closeEditor();
            return;
        }
        if (artifactTopicEvent.isHasEvent((Artifact)awa) || artifactTopicEvent.isReloaded((Artifact)awa)) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    editor.refresh();
                }
            });
        } else if (awa.isTeamWorkflow()) {
            boolean refreshNeeded = false;
            for (IAtsTask task : this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)awa)) {
                if (!artifactTopicEvent.isHasEvent((Artifact)task.getStoreObject())) continue;
                refreshNeeded = true;
                break;
            }
            if (!refreshNeeded) {
                for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews((IAtsTeamWorkflow)awa)) {
                    if (!artifactTopicEvent.isHasEvent((Artifact)review.getStoreObject())) continue;
                    refreshNeeded = true;
                    break;
                }
            }
            if (refreshNeeded) {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        editor.refresh();
                    }
                });
            }
        }
    }
}

