/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsCoreCodeXColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.util.StringLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class WebExportReviewedColumnUI
extends XViewerAtsCoreCodeXColumn {
    public static WebExportReviewedColumnUI instance = new WebExportReviewedColumnUI();
    private final AtsApi atsApi = AtsApiService.get();

    public static WebExportReviewedColumnUI getInstance() {
        return instance;
    }

    private WebExportReviewedColumnUI() {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.WebExportReviewed, AtsApiService.get());
    }

    @Override
    public WebExportReviewedColumnUI copy() {
        WebExportReviewedColumnUI newXCol = new WebExportReviewedColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            if (treeItem.getData() instanceof IAtsWorkItem) {
                IAtsWorkItem workItem = (IAtsWorkItem)treeItem.getData();
                return WebExportReviewedColumnUI.promptChange(Arrays.asList(workItem), this.atsApi);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public static boolean promptChange(IAtsWorkItem workItem, AtsApi atsApi) {
        return WebExportReviewedColumnUI.promptChange(Collections.singleton(workItem), atsApi);
    }

    public static boolean promptChange(Collection<IAtsWorkItem> workItems, AtsApi atsApi) {
        block10: {
            ArrayList<String> options;
            IAtsWorkItem workItem;
            block9: {
                workItem = workItems.iterator().next();
                options = new ArrayList<String>();
                for (String tag : workItem.getParentTeamWorkflow().getTeamDefinition().getTags()) {
                    if (!tag.startsWith("WebExportReviewOptions")) continue;
                    String exportOptions = tag.replaceFirst("WebExportReviewOptions=", "");
                    String[] stringArray = exportOptions.split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String option = stringArray[n2];
                        options.add(option);
                        ++n2;
                    }
                }
                if (!options.isEmpty()) break block9;
                AWorkbench.popup((String)("No Options Configured for Team " + workItem.getParentTeamWorkflow().getTeamDefinition().toStringWithId()));
                return false;
            }
            try {
                FilteredCheckboxTreeDialog dialog = new FilteredCheckboxTreeDialog("Select Reviewed", "Select Reviewed", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new StringLabelProvider(), null, true);
                dialog.setInput(options);
                List selected = atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WebExportReviewed);
                dialog.setInitialSelections((Collection)selected);
                if (dialog.open() == 1) break block10;
                IAtsChangeSet changes = atsApi.createChangeSet("Set");
                boolean clear = dialog.isClearSelected();
                if (clear) {
                    options.removeAll(dialog.getChecked());
                    for (IAtsWorkItem wi : workItems) {
                        changes.deleteAttributes((IAtsObject)wi, (AttributeTypeToken)AtsAttributeTypes.WebExportReviewed);
                    }
                } else {
                    ArrayList checked = new ArrayList();
                    checked.addAll(dialog.getChecked());
                    for (IAtsWorkItem wi : workItems) {
                        changes.setAttributeValuesAsStrings((IAtsObject)wi, (AttributeTypeToken)AtsAttributeTypes.WebExportReviewed, checked);
                    }
                }
                changes.executeIfNeeded();
                return true;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)Lib.exceptionToString((Exception)ex));
            }
        }
        return false;
    }

    @Override
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        if (element instanceof IAtsWorkItem) {
            return AtsApiService.get().getAttributeResolver().getAttributesToStringUniqueList((IAtsObject)((IAtsWorkItem)element), (AttributeTypeToken)AtsAttributeTypes.WebExportReviewed, ", ");
        }
        return "";
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
            for (TreeItem item : treeItems) {
                Artifact art;
                if (!(item.getData() instanceof IAtsWorkItem) || !((art = AtsApiService.get().getQueryServiceIde().getArtifact(item)) instanceof IAtsWorkItem)) continue;
                workItems.add((IAtsWorkItem)art);
            }
            WebExportReviewedColumnUI.promptChange(workItems, this.atsApi);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

