/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.ide.column.AbstractVersionSelectorUI;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingPreComputedColumnUI;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingValueProviderUI;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TargetedVersionColumnUI
extends AbstractVersionSelectorUI
implements BackgroundLoadingValueProviderUI,
IXViewerPreComputedColumn {
    public static TargetedVersionColumnUI instance = new TargetedVersionColumnUI();
    public AtomicBoolean loading = new AtomicBoolean(false);
    public AtomicBoolean loaded = new AtomicBoolean(false);
    protected Map<Long, String> idToValueMap = new HashMap<Long, String>();

    public TargetedVersionColumnUI() {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.TargetedVersionColumn);
    }

    public static TargetedVersionColumnUI getInstance() {
        return instance;
    }

    @Override
    public TargetedVersionColumnUI copy() {
        TargetedVersionColumnUI newXCol = new TargetedVersionColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public RelationTypeSide getRelation() {
        return AtsRelationTypes.TeamWorkflowTargetedForVersion_Version;
    }

    @Override
    public String getValue(IAtsWorkItem workItem, Map<Long, String> idToValueMap) {
        String value = super.getColumnText(workItem, null, 0);
        if (Strings.isValid((String)value)) {
            idToValueMap.put(workItem.getId(), value);
        }
        return value;
    }

    public String getValue(Object obj) {
        String value = super.getColumnText(obj, null, 0);
        if (Strings.isValid((String)value) && obj instanceof NamedId) {
            this.idToValueMap.put(((NamedId)obj).getId(), value);
        }
        return value;
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        this.preComputedValueMap = preComputedValueMap;
        this.loaded.set(false);
        this.loading.set(false);
        for (Object obj : objects) {
            this.preComputedValueMap.put(this.getKey(obj), "loading...");
        }
        BackgroundLoadingPreComputedColumnUI.startLoadingThread(this.getName(), objects, this.loading, this.loaded, (WorldXViewer)this.getXViewer(), preComputedValueMap, this);
    }

    @Override
    public String getColumnText(Object obj, XViewerColumn column, int columnIndex) {
        String value = BackgroundLoadingPreComputedColumnUI.getColumnText(obj, this.loading, this.loaded, this.preComputedValueMap, this);
        return value;
    }

    public String getText(Object obj, Long key, String cachedValue) {
        String value = BackgroundLoadingPreComputedColumnUI.getColumnText(obj, this.loading, this.loaded, this.preComputedValueMap, this);
        return value;
    }

    public Long getKey(Object obj) {
        if (obj instanceof Id) {
            return ((Id)obj).getId();
        }
        return Id.SENTINEL;
    }
}

