/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class RiskFactorColumnUI
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static RiskFactorColumnUI instance = new RiskFactorColumnUI();
    private final AtsApi atsApi = AtsApiService.get();

    public static RiskFactorColumnUI getInstance() {
        return instance;
    }

    private RiskFactorColumnUI() {
        super("ats.taskest.risk.factor", "Risk Factor", 40, XViewerAlign.Left, true, SortDataType.String, true, "");
    }

    public RiskFactorColumnUI copy() {
        RiskFactorColumnUI newXCol = new RiskFactorColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            if (treeItem.getData() instanceof IAtsWorkItem) {
                IAtsWorkItem workItem = (IAtsWorkItem)treeItem.getData();
                return RiskFactorColumnUI.promptChange(Arrays.asList(workItem), this.atsApi);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public static boolean promptChange(IAtsWorkItem workItem, AtsApi atsApi) {
        return RiskFactorColumnUI.promptChange(Collections.singleton(workItem), atsApi);
    }

    public static boolean promptChange(final Collection<IAtsWorkItem> workItems, final AtsApi atsApi) {
        try {
            final int result = MessageDialog.open((int)3, (Shell)Displays.getActiveShell(), (String)"Risk Factor", (String)"Risk Factor", (int)0, (String[])new String[]{"Low", "Medium", "High", "Clear", "Cancel"});
            if (result != 4) {
                Job signJob = new Job("Set Risk Factor"){

                    protected IStatus run(IProgressMonitor monitor) {
                        IAtsChangeSet changes = atsApi.createChangeSet("Set");
                        for (IAtsWorkItem workItem : workItems) {
                            if (result == 0) {
                                changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.RiskFactor, "Low");
                                continue;
                            }
                            if (result == 1) {
                                changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.RiskFactor, "Medium");
                                continue;
                            }
                            if (result == 2) {
                                changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.RiskFactor, "High");
                                continue;
                            }
                            if (result != 3) continue;
                            changes.deleteAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.RiskFactor);
                        }
                        changes.executeIfNeeded();
                        return Status.OK_STATUS;
                    }
                };
                Operations.scheduleJob((Job)signJob, (boolean)false, (int)20, null);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return true;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof IAtsWorkItem) {
                IAtsWorkItem workItem = (IAtsWorkItem)element;
                return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.RiskFactor, (Object)"");
            }
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
            for (TreeItem item : treeItems) {
                Artifact art;
                if (!(item.getData() instanceof IAtsWorkItem) || !((art = AtsApiService.get().getQueryServiceIde().getArtifact(item)) instanceof IAtsWorkItem)) continue;
                workItems.add((IAtsWorkItem)art);
            }
            RiskFactorColumnUI.promptChange(workItems, this.atsApi);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

