/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.PromptChangeUtil;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class PointsColumnUI
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static PointsColumnUI instance = new PointsColumnUI();
    private final AtsApi atsApi = AtsApiService.get();

    public static PointsColumnUI getInstance() {
        return instance;
    }

    private PointsColumnUI() {
        super("ats.wi.points", "Points", 40, XViewerAlign.Left, false, SortDataType.Integer, true, "");
    }

    public PointsColumnUI copy() {
        PointsColumnUI newXCol = new PointsColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block5: {
            AttributeTypeToken pointsAttrType;
            IAtsWorkItem workItem;
            Artifact useArt;
            block7: {
                block6: {
                    if (!(treeItem.getData() instanceof Artifact)) break block5;
                    useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                    if (useArt instanceof IAtsWorkItem) break block6;
                    return false;
                }
                workItem = (IAtsWorkItem)useArt;
                pointsAttrType = this.atsApi.getAgileService().getPointsAttrType(workItem);
                if (this.atsApi.getAttributeResolver().isAttributeTypeValid(workItem, pointsAttrType)) break block7;
                return false;
            }
            try {
                boolean modified = PointsColumnUI.promptChangePoints(workItem, pointsAttrType, this.atsApi);
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified) {
                    xViewer.update((Object)useArt, null);
                    return true;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean promptChangePoints(IAtsWorkItem workItem, AttributeTypeToken pointsAttrType, AtsApi atsApi) {
        return PointsColumnUI.promptChangePoints(Collections.singleton(workItem), pointsAttrType, atsApi);
    }

    public static boolean promptChangePoints(Collection<IAtsWorkItem> workItems, AttributeTypeToken pointsAttrType, AtsApi atsApi) {
        if (pointsAttrType == AtsAttributeTypes.PointsNumeric) {
            EntryDialog dialog = new EntryDialog("Enter Points", "Enter Points");
            dialog.setNumberFormat(NumberFormat.getInstance());
            if (dialog.open() == 0) {
                String entry = dialog.getEntry();
                if (Strings.isNumeric((String)entry)) {
                    try {
                        double points = Double.valueOf(entry);
                        IAtsChangeSet changes = atsApi.createChangeSet("Set Points");
                        for (IAtsWorkItem workItem : workItems) {
                            changes.setSoleAttributeValue((IAtsObject)workItem, pointsAttrType, (Object)points);
                        }
                        changes.executeIfNeeded();
                        return true;
                    }
                    catch (Exception exception) {}
                } else if (Strings.isInvalidOrBlank((String)entry)) {
                    IAtsChangeSet changes = atsApi.createChangeSet("Set Points");
                    for (IAtsWorkItem workItem : workItems) {
                        changes.deleteAttributes((IAtsObject)workItem, pointsAttrType);
                    }
                    changes.executeIfNeeded();
                }
            }
        } else {
            PromptChangeUtil.promptChangeAttribute(org.eclipse.osee.framework.jdk.core.util.Collections.castAll(workItems), pointsAttrType, true);
        }
        return false;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof IAtsWorkItem) {
                return this.atsApi.getAgileService().getPointsStr((IAtsWorkItem)element);
            }
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            AttributeTypeToken pointsAttrType = null;
            HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
            for (TreeItem item : treeItems) {
                if (!(item.getData() instanceof IAtsWorkItem)) continue;
                IAtsWorkItem workItem = (IAtsWorkItem)item.getData();
                AttributeTypeToken ptsAttrType = this.atsApi.getAgileService().getPointsAttrType(workItem);
                if (pointsAttrType == null) {
                    pointsAttrType = ptsAttrType;
                } else if (!pointsAttrType.equals(ptsAttrType)) {
                    throw new OseeArgumentException("Can not change points attribute for workflows of different attr types", new Object[0]);
                }
                Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
                if (!(art instanceof IAtsWorkItem)) continue;
                workItems.add((IAtsWorkItem)art);
            }
            if (pointsAttrType != null) {
                PointsColumnUI.promptChangePoints(workItems, pointsAttrType, this.atsApi);
            }
            return;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return;
        }
    }
}

