/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.HashSet;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class NumberOfTasksColumnUI
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static NumberOfTasksColumnUI instance = new NumberOfTasksColumnUI();

    public static NumberOfTasksColumnUI getInstance() {
        return instance;
    }

    private NumberOfTasksColumnUI() {
        super("ats.column.numberOfTasks", "Number of Tasks", 40, XViewerAlign.Center, false, SortDataType.Integer, false, null);
    }

    public NumberOfTasksColumnUI copy() {
        NumberOfTasksColumnUI newXCol = new NumberOfTasksColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        block5: {
            int num;
            block6: {
                if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                    HashSet<String> strs = new HashSet<String>();
                    for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(element)) {
                        String str = this.getColumnText(team, column, columnIndex);
                        if (!Strings.isValid((String)str)) continue;
                        strs.add(str);
                    }
                    return Collections.toString((String)", ", strs);
                }
                if (!(element instanceof TeamWorkFlowArtifact)) break block5;
                num = AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)((TeamWorkFlowArtifact)((Object)element))).size();
                if (num != 0) break block6;
                return "";
            }
            try {
                return String.valueOf(num);
            }
            catch (OseeCoreException ex) {
                LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
        }
        return "";
    }
}

