/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.UniversalGroup;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeArtifactDialog;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class GroupsColumnUI
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static GroupsColumnUI instance = new GroupsColumnUI();

    public static GroupsColumnUI getInstance() {
        return instance;
    }

    private GroupsColumnUI() {
        super("ats.column.groups", "Groups", 100, XViewerAlign.Left, false, SortDataType.String, true, "Groups");
    }

    public GroupsColumnUI copy() {
        GroupsColumnUI newXCol = new GroupsColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block4: {
            Artifact useArt;
            block5: {
                if (!(treeItem.getData() instanceof Artifact)) break block4;
                useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                if (useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) break block5;
                return false;
            }
            try {
                boolean modified = GroupsColumnUI.promptChangeGroups(Arrays.asList((TeamWorkFlowArtifact)useArt));
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified) {
                    useArt.persist("persist groups via alt-left-click");
                    xViewer.update((Object)useArt, null);
                    return true;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean promptChangeGroups(Collection<? extends AbstractWorkflowArtifact> awas) {
        HashSet selected = new HashSet();
        for (AbstractWorkflowArtifact abstractWorkflowArtifact : awas) {
            selected.addAll(abstractWorkflowArtifact.getRelatedArtifacts(CoreRelationTypes.UniversalGrouping_Group));
        }
        Collection collection = UniversalGroup.getGroupsNotRoot((BranchId)AtsApiService.get().getAtsBranch());
        FilteredCheckboxTreeArtifactDialog dialog = new FilteredCheckboxTreeArtifactDialog("Select Groups", "Select Groups", collection);
        dialog.setInitialSelections(selected);
        if (dialog.open() == 0) {
            for (AbstractWorkflowArtifact abstractWorkflowArtifact : awas) {
                Collection checked = dialog.getChecked();
                abstractWorkflowArtifact.setRelations(CoreRelationTypes.UniversalGrouping_Group, checked);
            }
            TransactionManager.persistInTransaction((String)"Set Groups", awas);
            return true;
        }
        return false;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                HashSet groups = new HashSet();
                Artifact actionArt = AtsApiService.get().getQueryServiceIde().getArtifact(element);
                groups.addAll(actionArt.getRelatedArtifacts(CoreRelationTypes.UniversalGrouping_Group));
                for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)actionArt)) {
                    groups.addAll(Collections.castAll((Collection)AtsApiService.get().getRelationResolver().getRelatedArtifacts((IAtsWorkItem)team, CoreRelationTypes.UniversalGrouping_Group)));
                }
                return Collections.toString((String)"; ", groups);
            }
            if (element instanceof Artifact) {
                return Collections.toString((String)"; ", (Iterable)AtsApiService.get().getQueryServiceIde().getArtifact(element).getRelatedArtifacts(CoreRelationTypes.UniversalGrouping_Group));
            }
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<AbstractWorkflowArtifact> awas = new HashSet<AbstractWorkflowArtifact>();
            for (TreeItem item : treeItems) {
                if (!(item.getData() instanceof Artifact)) continue;
                Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
                if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
                awas.add((AbstractWorkflowArtifact)art);
            }
            GroupsColumnUI.promptChangeGroups(awas);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

