/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.ChangeTypeColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsCoreCodeXColumn;
import org.eclipse.osee.ats.ide.workflow.chgtype.ChangeTypeDialog;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ChangeTypeColumnUI
extends XViewerAtsCoreCodeXColumn {
    public static ChangeTypeColumnUI instance = new ChangeTypeColumnUI();

    public static ChangeTypeColumnUI getInstance() {
        return instance;
    }

    private ChangeTypeColumnUI() {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.ChangeTypeColumn, AtsApiService.get());
    }

    @Override
    public ChangeTypeColumnUI copy() {
        ChangeTypeColumnUI newXCol = new ChangeTypeColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean promptChangeType(Collection<IAtsTeamWorkflow> teamWfs) {
        try {
            ChangeTypes changeType;
            for (IAtsTeamWorkflow teamWf : teamWfs) {
                if (!AtsApiService.get().getVersionService().isReleased(teamWf) && !AtsApiService.get().getVersionService().isVersionLocked(teamWf)) continue;
                AWorkbench.popup((String)"ERROR", (String)("Team Workflow\n \"" + teamWf.getName() + "\"\n version is locked or already released."));
                return false;
            }
            ChangeTypeDialog dialog = new ChangeTypeDialog(teamWfs, null);
            if (teamWfs.size() == 1 && (changeType = ChangeTypeColumn.getChangeType((IAtsWorkItem)((IAtsWorkItem)teamWfs.iterator().next()), (AtsApi)AtsApiService.get())) != null) {
                dialog.setSelected(changeType);
            }
            if (dialog.open() == 0) {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("ATS Prompt Change Type");
                ChangeTypes newChangeType = (ChangeTypes)dialog.getSelected();
                for (IAtsTeamWorkflow team : teamWfs) {
                    ChangeTypeColumn.setChangeType((IAtsObject)team, (ChangeTypes)newChangeType, (IAtsChangeSet)changes);
                }
                changes.executeIfNeeded();
            }
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't change Change Type", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block5: {
            Artifact useArt;
            block7: {
                block6: {
                    if (!(treeItem.getData() instanceof Artifact)) break block5;
                    useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                    if (useArt.getArtifactType().getMax((AttributeTypeToken)AtsAttributeTypes.ChangeType) == 1) break block6;
                    return false;
                }
                if (useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) break block7;
                AWorkbench.popup((String)"Invalid Selection", (String)"Column [%s] is not valid for selected", (Object[])new Object[]{treeColumn.getText()});
                return false;
            }
            try {
                boolean modified = ChangeTypeColumnUI.promptChangeType(Arrays.asList(new IAtsTeamWorkflow[]{(TeamWorkFlowArtifact)useArt}));
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified) {
                    useArt.persist("persist change type via alt-left-click");
                    xViewer.update((Object)useArt, null);
                    return true;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public Image getColumnImage(Object element, XViewerColumn column, int columnIndex) {
        try {
            ChangeTypes changeType;
            IAtsWorkItem workItem;
            IAtsTeamWorkflow useArt;
            if (element instanceof IAtsWorkItem && (useArt = (workItem = (IAtsWorkItem)element).getParentTeamWorkflow()) != null && (changeType = ChangeTypeColumn.getChangeType((IAtsWorkItem)workItem, (AtsApi)AtsApiService.get())) != null) {
                return ChangeTypeColumnUI.getImage(changeType);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return null;
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        HashSet<IAtsTeamWorkflow> awas = new HashSet<IAtsTeamWorkflow>();
        for (TreeItem item : treeItems) {
            if (!(item.getData() instanceof Artifact)) continue;
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
            awas.add((IAtsTeamWorkflow)art);
        }
        if (awas.isEmpty()) {
            AWorkbench.popup((String)"Invalid Selection", (String)"Column [%s] is not valid for selected", (Object[])new Object[]{treeColumn.getText()});
            return;
        }
        ChangeTypeColumnUI.promptChangeType(awas);
        ((XViewer)this.getXViewer()).update(awas.toArray(), null);
    }

    public static Image getImage(ChangeTypes type) {
        if (type == ChangeTypes.Problem || type == ChangeTypes.Fix) {
            return ImageManager.getImage((KeyedImage)FrameworkImage.PROBLEM);
        }
        if (type == ChangeTypes.Improvement || type == ChangeTypes.InitialDev) {
            return ImageManager.getImage((KeyedImage)FrameworkImage.GREEN_PLUS);
        }
        if (type == ChangeTypes.Support) {
            return ImageManager.getImage((KeyedImage)FrameworkImage.SUPPORT);
        }
        if (type == ChangeTypes.Refinement) {
            return ImageManager.getImage((KeyedImage)FrameworkImage.REFINEMENT);
        }
        return null;
    }
}

