/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.ide.column.IAtsXViewerPreComputedColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsCoreCodeXColumn;
import org.eclipse.osee.ats.ide.workflow.CollectorArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.MembersManager;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public abstract class AbstractMembersOrderColumnUI
extends XViewerAtsCoreCodeXColumn
implements IAtsXViewerPreComputedColumn {
    public static final Integer DEFAULT_WIDTH = 45;
    Map<Long, String> multiMembersValueMap = new HashMap<Long, String>();
    boolean loading = false;

    public AbstractMembersOrderColumnUI(AtsColumnTokensDefault.CoreCodeColumnTokenDefault columnToken) {
        super((AtsCoreCodeColumnToken)columnToken, AtsApiService.get());
    }

    public abstract Artifact getParentMembersArtifact(WorldXViewer var1);

    public abstract MembersManager<?> getMembersManager();

    @Override
    public String getText(Object obj, Long key, String cachedValue) {
        String result = "";
        if (!this.loading) {
            XViewer xViewer = (XViewer)this.getXViewer();
            if (obj instanceof Artifact && xViewer instanceof WorldXViewer) {
                WorldXViewer worldXViewer = (WorldXViewer)xViewer;
                CollectorArtifact parentMembersArtifact = (CollectorArtifact)this.getParentMembersArtifact(worldXViewer);
                if (parentMembersArtifact != null) {
                    if (Strings.isValid((String)cachedValue)) {
                        result = cachedValue;
                    }
                } else {
                    String cachedObjectValue = this.multiMembersValueMap.get(AtsApiService.get().getQueryServiceIde().getArtifact(obj).getId());
                    if (Strings.isValid((String)cachedObjectValue)) {
                        result = cachedObjectValue;
                    }
                }
            }
        }
        return result;
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        MembersManager<?> manager = this.getMembersManager();
        for (Object element : objects) {
            try {
                String value;
                if (!(element instanceof Artifact) || !(this.getXViewer() instanceof WorldXViewer)) continue;
                WorldXViewer worldXViewer = (WorldXViewer)this.getXViewer();
                CollectorArtifact parentMembersArtifact = (CollectorArtifact)this.getParentMembersArtifact(worldXViewer);
                Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(element);
                if (parentMembersArtifact != null) {
                    value = manager.getMemberOrder(parentMembersArtifact, artifact);
                    preComputedValueMap.put(this.getKey(element), value);
                    continue;
                }
                value = manager.getMemberOrder(artifact);
                this.multiMembersValueMap.put(this.getKey(element), value);
            }
            catch (OseeCoreException ex) {
                LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
        }
    }
}

