/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.jira;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.agile.jira.AbstractJiraSyncColumnUI;
import org.eclipse.osee.ats.ide.editor.IWfeEditorContributor;
import org.eclipse.osee.ats.ide.editor.WfeEditorContributors;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class JiraStoryLinkColumnUI
extends AbstractJiraSyncColumnUI {
    public static JiraStoryLinkColumnUI instance = new JiraStoryLinkColumnUI();

    public static JiraStoryLinkColumnUI getInstance() {
        return instance;
    }

    private JiraStoryLinkColumnUI() {
        super(AtsColumnTokensDefault.JiraStoryLinkColumn);
    }

    public JiraStoryLinkColumnUI copy() {
        JiraStoryLinkColumnUI newXCol = new JiraStoryLinkColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public String getValue(IAtsWorkItem workItem, Map<Long, String> idToValueMap) {
        if (workItem.isTeamWorkflow()) {
            return AtsApiService.get().getJiraService().getJiraStoryLink(workItem);
        }
        return "";
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        if (treeItem.getData() instanceof IAtsTeamWorkflow) {
            this.createStoryLink(Arrays.asList((IAtsTeamWorkflow)treeItem.getData()));
        }
        return super.handleAltLeftClick(treeColumn, treeItem);
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        HashSet<IAtsTeamWorkflow> teamWfs = new HashSet<IAtsTeamWorkflow>();
        for (TreeItem item : treeItems) {
            if (!(item.getData() instanceof IAtsTeamWorkflow)) continue;
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)item.getData();
            teamWfs.add(teamWf);
        }
        this.createStoryLink(teamWfs);
        super.handleColumnMultiEdit(treeColumn, treeItems);
    }

    private void createStoryLink(Collection<IAtsTeamWorkflow> teamWfs) {
        HashSet<IAtsTeamWorkflow> unlinkedTeamWfs = new HashSet<IAtsTeamWorkflow>();
        for (IAtsTeamWorkflow teamWf : teamWfs) {
            String storyId = AtsApiService.get().getJiraService().getJiraStoryLink((IAtsWorkItem)teamWf);
            if (!Strings.isInvalid((String)storyId)) continue;
            unlinkedTeamWfs.add(teamWf);
        }
        if (unlinkedTeamWfs.isEmpty()) {
            AWorkbench.popup((String)"No Team Workflows to Link");
            return;
        }
        XResultData rd = new XResultData();
        for (IWfeEditorContributor contrib : WfeEditorContributors.getContributors()) {
            contrib.createStoryLink(teamWfs, rd);
        }
        XResultDataUI.report((XResultData)rd, (String)this.getName());
    }
}

