/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.jira;

import java.util.Map;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.agile.jira.AbstractJiraSyncColumnUI;
import org.eclipse.osee.ats.ide.internal.AtsApiService;

public class JiraAssigneeColumnUI
extends AbstractJiraSyncColumnUI {
    public static JiraAssigneeColumnUI instance = new JiraAssigneeColumnUI();

    public static JiraAssigneeColumnUI getInstance() {
        return instance;
    }

    private JiraAssigneeColumnUI() {
        super(AtsColumnTokensDefault.JiraAssigneeColumn);
    }

    public JiraAssigneeColumnUI copy() {
        JiraAssigneeColumnUI newXCol = new JiraAssigneeColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public String getValue(IAtsWorkItem workItem, Map<Long, String> idToValueMap) {
        IAgileSprint sprint;
        if (workItem.isTeamWorkflow() && (sprint = AtsApiService.get().getAgileService().getSprint((IAtsTeamWorkflow)workItem)) != null) {
            AtsUser user = AtsApiService.get().getJiraService().getJiraAssignee(workItem);
            if (user != null) {
                return user.getName();
            }
            return "Not in JIRA";
        }
        return "";
    }
}

