/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.jira;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.jira.JiraSearch;
import org.eclipse.osee.ats.core.column.SprintColumn;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingPreComputedColumnUI;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractJiraSyncColumnUI
extends BackgroundLoadingPreComputedColumnUI {
    private static final LoadingCache<IAtsWorkItem, JiraSearch> workIdtoJiraSearch = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<IAtsWorkItem, JiraSearch>(){

        public JiraSearch load(IAtsWorkItem workItem) {
            return AtsApiService.get().getJiraService().search(workItem);
        }
    });
    private static final LoadingCache<IAtsWorkItem, AtsUser> workIdtoJiraAssignee = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<IAtsWorkItem, AtsUser>(){

        public AtsUser load(IAtsWorkItem workItem) {
            return AtsApiService.get().getJiraService().getJiraAssignee(workItem);
        }
    });

    protected AbstractJiraSyncColumnUI(AtsColumnTokensDefault.CoreCodeColumnTokenDefault codeCol) {
        super(codeCol);
    }

    public static AtsUser getJiraAssignee(IAtsWorkItem workItem) {
        try {
            return (AtsUser)workIdtoJiraAssignee.get((Object)workItem);
        }
        catch (Exception ex) {
            OseeLog.log(AbstractJiraSyncColumnUI.class, (Level)Level.WARNING, (String)("Exception getting assignee: " + Lib.exceptionToString((Exception)ex)));
            return null;
        }
    }

    @Override
    public String getValue(IAtsWorkItem workItem, Map<Long, String> idToValueMap) {
        return SprintColumn.getTextValue((IAtsObject)workItem, (AtsApi)AtsApiService.get());
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        return false;
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
    }

    public static JiraSearch search(IAtsWorkItem workItem) {
        try {
            return (JiraSearch)workIdtoJiraSearch.get((Object)workItem);
        }
        catch (Exception ex) {
            JiraSearch srch = new JiraSearch();
            srch.getRd().errorf(Lib.exceptionToString((Exception)ex), new Object[0]);
            return srch;
        }
    }
}

