/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.task;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.task.create.TasksFromAction;
import org.eclipse.osee.ats.api.util.AtsConstants;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryEntryDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class CreateTasksFromActions
extends AbstractAtsAction {
    private final Collection<TeamWorkFlowArtifact> teamWfs;
    private ISelectedAtsArtifacts selectedAtsArtifacts;

    public CreateTasksFromActions(Collection<TeamWorkFlowArtifact> teamWfs) {
        super(AtsConstants.CreateTasksFromActions.name());
        this.teamWfs = teamWfs;
    }

    public CreateTasksFromActions(ISelectedAtsArtifacts selectedAtsArtifacts) {
        super(AtsConstants.CreateTasksFromActions.name());
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.teamWfs = null;
    }

    private Collection<TeamWorkFlowArtifact> getTeamWfs() {
        if (this.teamWfs != null) {
            return this.teamWfs;
        }
        return this.selectedAtsArtifacts.getSelectedTeamWorkflowArtifacts();
    }

    @Override
    public void run() {
        Collection<TeamWorkFlowArtifact> useTeamWfs = this.getTeamWfs();
        if (useTeamWfs.isEmpty()) {
            AWorkbench.popup((String)"Team Workflow(s) Must Be Selected");
            return;
        }
        AtsApiIde atsApi = AtsApiService.get();
        for (TeamWorkFlowArtifact teamWf : useTeamWfs) {
            if (!teamWf.isCompletedOrCancelled()) continue;
            AWorkbench.popup((String)"Can't create tasks off Completed/Cancelled workflows");
            return;
        }
        String msg = "This operation will:\n\n1. Validate that the Team Workflow for the given ATS Id is in a Working state.\n2. Create an ATS Task for each selected Team Workflow.\n3. Relate the new Task to the corresponding Team Workflow.\n4. Cancel the related Team Workflow with a comment about related Task.";
        EntryEntryDialog diag = new EntryEntryDialog(this.getText(), msg, "Destination Team Workflow ATS Id", "Enter Reason");
        diag.setEntry2("Moved to Task - See Related");
        if (diag.open() == 0) {
            String atsId = diag.getEntry();
            String reason = diag.getEntry2();
            if (!Strings.isValid((String)atsId) || !Strings.isValid((String)reason)) {
                AWorkbench.popup((String)"Must enter Destination ATS Id and Reason");
                return;
            }
            IAtsWorkItem destTeamWf = atsApi.getWorkItemService().getWorkItemByAtsId(atsId);
            if (destTeamWf == null) {
                AWorkbench.popup((String)"Destination Team Workflow [%s] does not exist", (String)atsId);
                return;
            }
            if (!destTeamWf.isTeamWorkflow()) {
                AWorkbench.popup((String)"Destination Workflow Item [%s] is not a Team Workflow", (String)atsId);
                return;
            }
            if (destTeamWf.isCompletedOrCancelled()) {
                AWorkbench.popupf((String)"Destination Team Workflow in [%s] state: %s", (Object[])new Object[]{destTeamWf.getCurrentStateType(), destTeamWf.toStringWithAtsId()});
                return;
            }
            TasksFromAction tfa = new TasksFromAction();
            tfa.setCreatedBy(atsApi.getUserService().getCurrentUser().getArtifactId());
            tfa.setReason(reason);
            tfa.setDestTeamWf(destTeamWf.getArtifactToken());
            for (IAtsTeamWorkflow iAtsTeamWorkflow : useTeamWfs) {
                tfa.getSourceTeamWfs().add(iAtsTeamWorkflow.getArtifactToken());
            }
            tfa = atsApi.getServerEndpoints().getTaskEp().create(tfa);
            XResultDataUI.report((XResultData)tfa.getRd(), (String)this.getText());
            if (tfa.getRd().isSuccess()) {
                atsApi.getStoreService().reload(Arrays.asList(destTeamWf));
                atsApi.getStoreService().reload((Collection)Collections.castAll(useTeamWfs));
                WorkflowEditor.edit(destTeamWf);
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.DUPLICATE);
    }
}

