/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.newaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.actions.newaction.CreateNewActionProvider;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XAgileFeatureHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XAssigneesHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelActionableItemSelection;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkChangeTypeSelection;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkPrioritySelection;
import org.eclipse.osee.ats.ide.util.widgets.XOriginatorHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XSprintHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XTargetedVersionHyperlinkWidget;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidgetUtility;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.DefaultXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetPage;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Bundle;

public class CreateNewActionBlam
extends AbstractBlam
implements INewActionListener {
    protected static final String BLAM_DESCRIPTION = "Select options to create new ATS Action";
    protected static final String TITLE = "Title";
    protected static final String PROGRAM = "Program";
    protected static final String DESCRIPTION = "Description";
    protected static final String CHANGE_TYPE = "Change Type";
    protected static final String PRIORITY = "Priority";
    protected static final String NEED_BY = "Need By";
    protected XText titleWidget;
    protected XText descWidget;
    protected XHyperlinkChangeTypeSelection changeTypeWidget;
    protected XHyperlinkPrioritySelection priorityWidget;
    protected XHyperlabelActionableItemSelection aiWidget;
    protected final AtsApi atsApi;
    protected XWidgetBuilder mainWb;
    protected XWidgetBuilder teamWb;
    private ActionResult actionResult;
    private Composite teamComp;
    private static Set<CreateNewActionProvider> providerExtensionItems = new HashSet<CreateNewActionProvider>();
    private final Set<CreateNewActionProvider> handledExtensionItems = new HashSet<CreateNewActionProvider>();
    private IManagedForm form;
    private Section section;
    private Composite comp;
    private final Collection<XWidget> teamXWidgets = new ArrayList<XWidget>();
    private final HashCollection<IAtsTeamDefinition, XWidget> teamDefToWidgets = new HashCollection();

    public CreateNewActionBlam() {
        this("Create New Action", BLAM_DESCRIPTION);
    }

    public CreateNewActionBlam(String name, String desc) {
        super(name, desc, null);
        this.atsApi = AtsApiService.get();
    }

    protected boolean isValidEntry() {
        return true;
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        Priorities priority;
        ChangeTypes cType;
        String desc;
        this.variableMap = variableMap;
        final AtomicBoolean valid = new AtomicBoolean(true);
        String title = variableMap.getString(TITLE);
        if (Strings.isInValid((String)title)) {
            this.log(new String[]{"Enter Title"});
            valid.set(false);
        }
        if (Strings.isInValid((String)(desc = variableMap.getString(DESCRIPTION)))) {
            this.log(new String[]{"Enter Description"});
            valid.set(false);
        }
        if ((cType = (ChangeTypes)variableMap.getValue(CHANGE_TYPE)) == null || cType == ChangeTypes.None) {
            this.log(new String[]{"Invalid Change Type"});
            valid.set(false);
        }
        if ((priority = (Priorities)variableMap.getValue(PRIORITY)) == null) {
            this.log(new String[]{"Select Priority"});
            valid.set(false);
        }
        Date needBy = (Date)variableMap.getValue(NEED_BY);
        Collection<IAtsActionableItem> actionableItems = this.aiWidget.getSelectedActionableItems();
        if (actionableItems.isEmpty()) {
            this.log(new String[]{"Must select Actionable Item(s)"});
            valid.set(false);
        }
        String priorityStr = Priorities.Three.name();
        if (priority != null) {
            priorityStr = priority.getName();
        }
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (XWidget widget : CreateNewActionBlam.this.teamXWidgets) {
                    IStatus status = widget.isValid();
                    if (status.isOK()) continue;
                    CreateNewActionBlam.this.log(new String[]{status.getMessage()});
                    valid.set(false);
                }
            }
        }, (boolean)true);
        for (CreateNewActionProvider provider : this.handledExtensionItems) {
            Result result = provider.isActionValidToCreate(actionableItems);
            if (!result.isFalse()) continue;
            this.log(new String[]{result.getText()});
            valid.set(false);
        }
        if (!this.isValidEntry() || !valid.get()) {
            return;
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getName());
        this.actionResult = this.atsApi.getActionService().createAction(this.atsApi.getUserService().getCurrentUser(), title, desc, cType, priorityStr, false, needBy, actionableItems, new Date(), this.atsApi.getUserService().getCurrentUser(), Collections.singleton(this), changes);
        if (this.actionResult.getResults().isErrors()) {
            XResultDataUI.report((XResultData)this.actionResult.getResults(), (String)this.getTitle());
            return;
        }
        for (CreateNewActionProvider provider : this.handledExtensionItems) {
            provider.createActionCompleted(this.actionResult, changes);
        }
        changes.execute();
        if (this.actionResult.getResults().isErrors()) {
            this.log(new String[]{this.actionResult.getResults().toString()});
            return;
        }
        Collection teamWfs = this.actionResult.getTeamWfs();
        if (teamWfs.size() == 1) {
            WorkflowEditor.edit((IAtsWorkItem)teamWfs.iterator().next());
        } else {
            WorldEditor.open(new WorldEditorSimpleProvider("New Action Workflows", AtsObjects.getArtifacts((Collection)teamWfs)));
        }
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        this.mainWb = new XWidgetBuilder();
        this.mainWb.andXText(TITLE, CoreAttributeTypes.Name).andRequired().endWidget();
        this.mainWb.andXHyperlinkActionableItemActive().andRequired().endWidget();
        this.mainWb.andXText((AttributeTypeToken)AtsAttributeTypes.Description).andHeight(80).andRequired().endWidget();
        this.addWidgetsAfterDescription(this.mainWb);
        this.mainWb.andChangeType(ChangeTypes.DEFAULT_CHANGE_TYPES).andRequired().endWidget();
        this.mainWb.andPriority().andRequired().endWidget();
        this.addWidgetAfterPriority();
        this.mainWb.andXHyperLinkDate(AtsAttributeTypes.NeedBy.getUnqualifiedName()).endComposite().endWidget();
        return this.mainWb.getItems();
    }

    protected void addWidgetsAfterDescription(XWidgetBuilder wb) {
    }

    public void createWidgets(Composite comp, IManagedForm form, Section section, XWidgetPage widgetPage) {
        this.comp = comp;
        this.form = form;
        this.section = section;
    }

    private void updateTeamComposites(Collection<IAtsActionableItem> ais) {
        try {
            this.teamXWidgets.clear();
            this.teamDefToWidgets.clear();
            if (Widgets.isAccessible((Widget)this.teamComp)) {
                this.teamComp.dispose();
            }
            this.teamComp = new Composite(this.comp, 0);
            this.teamComp.setLayout((Layout)new GridLayout(1, false));
            this.teamComp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.handledExtensionItems.clear();
            Collection<IAtsTeamDefinition> uniqueTeamDefs = this.getUniqueTeamDefs(ais);
            this.teamWb = new XWidgetBuilder();
            for (CreateNewActionProvider item : this.getCreateNewActionProviderExtensions()) {
                boolean hasProviderXWidgetExtensions;
                if (this.handledExtensionItems.contains(item) || !(hasProviderXWidgetExtensions = item.hasProviderXWidgetExtensions(this.aiWidget.getSelectedActionableItems()))) continue;
                this.teamWb.andXLabel(String.format("------- Additional Items for [%s] ------- ", item.getClass().getSimpleName()));
                for (IAtsTeamDefinition teamDef : uniqueTeamDefs) {
                    this.teamWb.andXLabel(String.format("      --- Items for Team Def [%s] ---", teamDef.getName()));
                    item.getAdditionalXWidgetItems(this.teamWb, teamDef);
                }
                this.handledExtensionItems.add(item);
            }
            List layoutDatas = this.teamWb.getItems();
            if (!layoutDatas.isEmpty()) {
                try {
                    DefaultXWidgetOptionResolver optionResolver = new DefaultXWidgetOptionResolver();
                    XWidgetPage widgetPage = new XWidgetPage(layoutDatas, (IXWidgetOptionResolver)optionResolver);
                    widgetPage.createBody(this.form, this.teamComp, null, null, true);
                    for (XWidget widget : widgetPage.getDynamicXWidgetLayout().getXWidgets()) {
                        this.teamXWidgets.add(widget);
                        for (CreateNewActionProvider provider : this.getCreateNewActionProviderExtensions()) {
                            provider.widgetCreated(widget, this.form.getToolkit(), null, widgetPage.getDynamicXWidgetLayout(), null, true);
                        }
                    }
                    XWidgetUtility.setLabelFontsBold((Collection)widgetPage.getDynamicXWidgetLayout().getXWidgets());
                    for (XWidget widget : widgetPage.getDynamicXWidgetLayout().getXWidgets()) {
                        widget.validate();
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
            for (XWidget widget : this.getBlamWidgets()) {
                widget.validate();
            }
            this.teamComp.getParent().layout(true, true);
            this.teamComp.getParent().getParent().layout(true, true);
            this.form.reflow(true);
            this.section.layout(true, true);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private Collection<IAtsTeamDefinition> getUniqueTeamDefs(Collection<IAtsActionableItem> ais) {
        HashSet<IAtsTeamDefinition> uniqueTeamDefs = new HashSet<IAtsTeamDefinition>();
        for (IAtsActionableItem ai : ais) {
            Collection teamDefs = this.atsApi.getTeamDefinitionService().getImpactedTeamDefInherited(ai);
            uniqueTeamDefs.addAll(teamDefs);
        }
        return uniqueTeamDefs;
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(TITLE)) {
            this.titleWidget = (XText)xWidget;
            this.titleWidget.getLabelWidget().addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (event.button == 3) {
                        CreateNewActionBlam.this.handlePopulateWithDebugInfo();
                    }
                }
            });
        } else if (xWidget.getLabel().equals(DESCRIPTION)) {
            this.descWidget = (XText)xWidget;
        } else if (xWidget.getLabel().equals(CHANGE_TYPE)) {
            this.changeTypeWidget = (XHyperlinkChangeTypeSelection)xWidget;
            this.setChangeTypeWidget(this.changeTypeWidget);
        } else if (xWidget.getLabel().equals(PRIORITY)) {
            this.priorityWidget = (XHyperlinkPrioritySelection)xWidget;
        } else if (xWidget instanceof XHyperlabelActionableItemSelection) {
            this.aiWidget = (XHyperlabelActionableItemSelection)xWidget;
            this.aiWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    Collection<IAtsActionableItem> ais = CreateNewActionBlam.this.aiWidget.getSelectedActionableItems();
                    CreateNewActionBlam.this.updateTeamComposites(ais);
                    if (!ais.isEmpty()) {
                        IAtsActionableItem ai = ais.iterator().next();
                        List changeTypeOptions = CreateNewActionBlam.this.atsApi.getWorkItemService().getChangeTypeOptions((IAtsObject)ai);
                        CreateNewActionBlam.this.changeTypeWidget.setSelectable(changeTypeOptions);
                        List priorityOptions = CreateNewActionBlam.this.atsApi.getWorkItemService().getPrioritiesOptions((IAtsObject)ai);
                        CreateNewActionBlam.this.priorityWidget.setSelectable(priorityOptions);
                    }
                }
            });
        }
        for (CreateNewActionProvider provider : this.getCreateNewActionProviderExtensions()) {
            provider.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        }
    }

    private Collection<ChangeTypes> setChangeTypeWidget(XHyperlinkChangeTypeSelection changeWidget) {
        Collection<IAtsActionableItem> ais = this.aiWidget.getSelectedActionableItems();
        if (ais == null || ais.isEmpty()) {
            this.logf("Must Select Actionable Item(s) First", new Object[0]);
            return Collections.emptyList();
        }
        IAtsActionableItem ai = ais.iterator().next();
        List changeTypes = this.atsApi.getWorkItemService().getChangeTypeOptions((IAtsObject)ai);
        changeWidget.setSelectable(changeTypes);
        return changeTypes;
    }

    public void handlePopulateWithDebugInfo() {
        String title = "New Action " + this.atsApi.getRandomNum();
        this.handlePopulateWithDebugInfo(title);
    }

    public void handlePopulateWithDebugInfo(String title) {
        try {
            ArrayList<IAtsActionableItem> ais = new ArrayList<IAtsActionableItem>();
            for (IAtsActionableItem ai : this.atsApi.getConfigService().getConfigurations().getIdToAi().values()) {
                if (ai.getName().equals("Framework")) {
                    ais.add(ai);
                    continue;
                }
                if (!ai.getName().equals("SAW Requirements")) continue;
                ais.add(ai);
            }
            this.aiWidget.setSelectedAIs(ais);
            this.titleWidget.set(title);
            this.descWidget.set("see title");
            Collection<ChangeTypes> cTypes = this.setChangeTypeWidget(this.changeTypeWidget);
            this.changeTypeWidget.setSelected(cTypes.iterator().next().name());
            this.priorityWidget.setSelected("3");
            for (CreateNewActionProvider provider : this.getCreateNewActionProviderExtensions()) {
                provider.handlePopulateWithDebugInfo(title);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private Set<CreateNewActionProvider> getCreateNewActionProviderExtensions() {
        IExtension[] extensions;
        if (!providerExtensionItems.isEmpty()) {
            return providerExtensionItems;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.osee.ats.ide.CreateNewActionProvider");
        if (point == null) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't access CreateNewActionProvider extension point");
            return providerExtensionItems;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String classname = null;
            String bundleName = null;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (el.getName().equals("CreateNewActionProvider")) {
                    classname = el.getAttribute("classname");
                    bundleName = el.getContributor().getName();
                    if (classname != null && bundleName != null) {
                        Bundle bundle = Platform.getBundle((String)bundleName);
                        try {
                            Class taskClass = bundle.loadClass(classname);
                            Object obj = taskClass.newInstance();
                            providerExtensionItems.add((CreateNewActionProvider)obj);
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error loading CreateNewActionProvider extension", (Throwable)ex);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return providerExtensionItems;
    }

    public String getRunText() {
        return "Create New Action";
    }

    public String getOutputMessage() {
        return "Not yet run.";
    }

    public String getTabTitle() {
        return "New Action";
    }

    public String getTitle() {
        return this.getName();
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavItemCat.TOP);
    }

    public Image getImage() {
        return ImageManager.getImage((OseeImage)AtsImage.NEW_ACTION);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.NEW_ACTION);
    }

    public ActionResult getActionResult() {
        return this.actionResult;
    }

    protected void addWidgetAfterPriority() {
    }

    protected int getChangeTypeRowColumns() {
        return 6;
    }

    public void teamCreated(final IAtsAction action, final IAtsTeamWorkflow teamWf, final IAtsChangeSet changes) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (XWidget widget : CreateNewActionBlam.this.teamXWidgets) {
                    block19: {
                        XAgileFeatureHyperlinkWidget featureWidget;
                        Collection<IAgileFeatureGroup> features;
                        block17: {
                            AttributeTypeToken attrType;
                            block18: {
                                if (!teamWf.getTeamDefinition().getId().equals(widget.getTeamId().getId())) continue;
                                if (!widget.getAttributeType().isValid()) break block17;
                                attrType = widget.getAttributeType();
                                if (!widget.isMultiSelect()) break block18;
                                ArrayList objs = new ArrayList();
                                for (Object obj : widget.getValues()) {
                                    objs.add(obj);
                                }
                                changes.setAttributeValues((IAtsObject)teamWf, attrType, objs);
                                break block19;
                            }
                            Object obj = widget.getData();
                            if (obj == null) break block19;
                            if (obj instanceof String && Strings.isInvalid((String)((String)obj))) continue;
                            changes.addAttribute((IAtsObject)teamWf, attrType, obj);
                            break block19;
                        }
                        if (widget.getLabel().equals("Originator")) {
                            XOriginatorHyperlinkWidget orig = (XOriginatorHyperlinkWidget)widget;
                            AtsUser originator = orig.getSelected();
                            if (originator != null) {
                                changes.setCreatedBy((IAtsWorkItem)teamWf, originator, false, new Date());
                            }
                        } else if (widget.getLabel().equals("Assignees")) {
                            XAssigneesHyperlinkWidget assign = (XAssigneesHyperlinkWidget)widget;
                            Collection<AtsUser> assignees = assign.getSelected();
                            if (assignees != null) {
                                changes.setAssignees((IAtsWorkItem)teamWf, assignees);
                            }
                        } else if (widget.getLabel().equals("Sprint")) {
                            XSprintHyperlinkWidget sprintWidget = (XSprintHyperlinkWidget)widget;
                            IAgileSprint sprint = sprintWidget.getSelected();
                            if (sprint != null) {
                                changes.relate((Object)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem, (Object)teamWf);
                            }
                        } else if (widget.getLabel().equals("Targeted Version")) {
                            XTargetedVersionHyperlinkWidget verWidget = (XTargetedVersionHyperlinkWidget)widget;
                            IAtsVersion version = verWidget.getSelected();
                            if (version != null) {
                                changes.relate((Object)teamWf, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version, (Object)version);
                            }
                        } else if (widget.getLabel().equals("Feature Group") && !(features = (featureWidget = (XAgileFeatureHyperlinkWidget)widget).getFeatures()).isEmpty()) {
                            for (IAgileFeatureGroup feature : features) {
                                changes.relate((Object)feature, AtsRelationTypes.AgileFeatureToItem_AtsItem, (Object)teamWf);
                            }
                        }
                    }
                    for (CreateNewActionProvider provider : CreateNewActionBlam.this.getCreateNewActionProviderExtensions()) {
                        provider.teamCreated(action, teamWf, CreateNewActionBlam.this.teamXWidgets, changes);
                    }
                }
            }
        }, (boolean)true);
    }
}

