/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.newaction;

import java.util.List;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.newaction.CreateNewActionBlam;
import org.eclipse.osee.ats.ide.editor.tab.members.IMemberProvider;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelActionableItemSelection;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetPage;

public class CreateNewActionAtLocactionBlam
extends CreateNewActionBlam {
    private final IMemberProvider memberProvider;
    private final List<IAtsActionableItem> aias;
    private final Artifact dropTarget;

    public CreateNewActionAtLocactionBlam(IMemberProvider memberProvider, List<IAtsActionableItem> aias, Artifact dropTarget) {
        super("Create New Action At This Location", "Select options to create new ATS Action and add to [" + memberProvider.getArtifact().getName() + "] " + (dropTarget == null ? "to the end" : "before item " + dropTarget.toStringWithId()));
        this.memberProvider = memberProvider;
        this.aias = aias;
        this.dropTarget = dropTarget;
    }

    public void inputSectionCreated(XWidgetPage widgetPage) {
        XHyperlabelActionableItemSelection aiWidget = (XHyperlabelActionableItemSelection)widgetPage.getLayoutData("Actionable Item(s)").getXWidget();
        if (this.aias.isEmpty()) {
            this.aias.addAll(AtsApiService.get().getActionableItemService().getTopLevelActionableItems(Active.Active));
        }
        aiWidget.setAis(this.aias);
    }

    @Override
    public void teamCreated(IAtsAction action, IAtsTeamWorkflow teamWf, IAtsChangeSet changes) {
        Artifact collectorArt = this.memberProvider.getArtifact();
        List related = collectorArt.getRelatedArtifacts(this.memberProvider.getMemberRelationTypeSide());
        if (!related.contains(teamWf.getStoreObject())) {
            changes.relate((ArtifactId)collectorArt, this.memberProvider.getMemberRelationTypeSide(), (ArtifactId)teamWf.getStoreObject());
        }
        if (this.dropTarget != null) {
            collectorArt.setRelationOrder(this.memberProvider.getMemberRelationTypeSide(), this.dropTarget, false, AtsApiService.get().getQueryServiceIde().getArtifact(teamWf));
            if (collectorArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                AtsApiService.get().getGoalMembersCache().decache((GoalArtifact)collectorArt);
            } else if (this.memberProvider.isSprint()) {
                AtsApiService.get().getSprintItemsCache().decache((SprintArtifact)collectorArt);
            }
        }
        changes.add((Object)collectorArt);
    }
}

