/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.jira;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.program.Program;

public class ShowJiraStoryAction
extends AbstractAtsAction {
    private final ISelectedAtsArtifacts selectedAtsArtifacts;

    public ShowJiraStoryAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.setToolTipText("Show Related JIRA Story");
    }

    @Override
    public void runWithException() {
        XResultData rd = new XResultData();
        rd.log(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "\n");
        Artifact wfArt = this.selectedAtsArtifacts.getSelectedWorkflowArtifacts().iterator().next();
        String jiraStoryId = (String)wfArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.JiraStoryId, (Object)"");
        if (Strings.isValid((String)jiraStoryId)) {
            String link = String.valueOf(AtsApiService.get().getJiraService().getJiraBasePath()) + "browse/" + jiraStoryId;
            rd.log(link);
            Program.launch((String)link);
        } else {
            AWorkbench.popup((String)"No JIRA Story Linked to this Team Workflow");
        }
    }

    public ImageDescriptor getImageDescriptor() {
        Artifact wfArt = this.selectedAtsArtifacts.getSelectedWorkflowArtifacts().iterator().next();
        String jiraStoryId = (String)wfArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.JiraStoryId, (Object)"");
        if (Strings.isValid((String)jiraStoryId)) {
            return ImageManager.getImageDescriptor((OseeImage)AtsImage.JIRA_LINKED);
        }
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.JIRA);
    }
}

