/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.jira;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.jira.CreateStoryResponse;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.jira.Issue;
import org.eclipse.osee.ats.api.workflow.jira.JiraSearch;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.agile.jira.AbstractJiraSyncColumnUI;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;

public abstract class CreateStoryAction
extends AbstractAtsAction {
    private final ISelectedAtsArtifacts selectedAtsArtifacts;
    private XResultData rd;

    public CreateStoryAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.setToolTipText("Create JIRA Story");
    }

    @Override
    public void runWithException() {
        this.rd = new XResultData();
        this.rd.log(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "\n");
        for (final Artifact wfArt : this.selectedAtsArtifacts.getSelectedWorkflowArtifacts()) {
            final IAtsWorkItem workItem = AtsApiService.get().getWorkItemService().getWorkItem((ArtifactToken)wfArt);
            this.rd.log("Team Workflow: " + workItem.toStringWithAtsId() + "\n");
            try {
                if (!workItem.isTeamWorkflow()) {
                    AWorkbench.popup((String)"Must be Team Workflow");
                    continue;
                }
                String jiraStoryId = (String)wfArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.JiraStoryId, (Object)"");
                if (Strings.isValid((String)jiraStoryId)) {
                    AWorkbench.popup((String)("JIRA Story " + jiraStoryId + " is already created and mapped to this Team Workflow"));
                    continue;
                }
                if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Create JIRA Story", (String)"Create JIRA Story and link to this Team Workflow\n\nAre you sure?")) continue;
                JiraSearch srch = AbstractJiraSyncColumnUI.search(workItem);
                if (srch.issues != null && !srch.issues.isEmpty() && Strings.isValid((String)(jiraStoryId = ((Issue)srch.issues.iterator().next()).key)) && MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Already Exists", (String)String.format("This workflow %s has story %s created, Link to ATS?", workItem.getAtsId(), jiraStoryId))) {
                    IAtsChangeSet changes = AtsApiService.get().createChangeSet("Link JIRA Story");
                    changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.JiraStoryId, jiraStoryId);
                    changes.execute();
                    AWorkbench.popup((String)"Story Linked");
                    continue;
                }
                Job createJiraStory = new Job("Creating JIRA Story"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            String createJson = CreateStoryAction.this.getCreateJson(workItem, CreateStoryAction.this.rd);
                            if (CreateStoryAction.this.rd.isErrors()) {
                                XResultDataUI.report((XResultData)CreateStoryAction.this.rd, (String)CreateStoryAction.this.getText());
                                return Status.OK_STATUS;
                            }
                            CreateStoryAction.this.rd.logf("Json: \n\n%s\n\n", new Object[]{createJson});
                            String jiraIssue = AtsApiService.get().getServerEndpoints().getJiraEndpoint().createJiraIssue(createJson);
                            if (jiraIssue.contains("errorMessages")) {
                                CreateStoryAction.this.rd.errorf("%s", new Object[]{jiraIssue});
                            } else {
                                CreateStoryAction.this.rd.log("\n\n" + jiraIssue);
                                CreateStoryResponse createResp = (CreateStoryResponse)JsonUtil.readValue((String)jiraIssue, CreateStoryResponse.class);
                                wfArt.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.JiraStoryId, (Object)createResp.getKey());
                                wfArt.persist(CreateStoryAction.this.getText());
                                String link = String.valueOf(AtsApiService.get().getJiraService().getJiraBasePath()) + "browse/" + createResp.getKey();
                                CreateStoryAction.this.rd.log(link);
                                Program.launch((String)link);
                            }
                            if (CreateStoryAction.this.rd.isErrors()) {
                                XResultDataUI.report((XResultData)CreateStoryAction.this.rd, (String)CreateStoryAction.this.getText());
                            }
                        }
                        catch (Exception ex) {
                            CreateStoryAction.this.rd.log(Lib.exceptionToString((Exception)ex));
                            XResultDataUI.report((XResultData)CreateStoryAction.this.rd, (String)CreateStoryAction.this.getText());
                        }
                        return Status.OK_STATUS;
                    }
                };
                Jobs.startJob((Job)createJiraStory);
            }
            catch (Exception ex) {
                this.rd.log(Lib.exceptionToString((Exception)ex));
            }
            if (!this.rd.isErrors()) continue;
            XResultDataUI.report((XResultData)this.rd, (String)((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    protected abstract String getCreateJson(IAtsWorkItem var1, XResultData var2);

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.JIRA_ADD);
    }

    public XResultData getRd() {
        return this.rd;
    }

    public void setRd(XResultData rd) {
        this.rd = rd;
    }
}

