/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.List;
import org.eclipse.nebula.widgets.xviewer.core.model.ColumnData;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.customize.IXViewerCustomizations;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.world.WorldComposite;
import org.eclipse.osee.ats.ide.world.WorldXViewerFactory;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class WorldViewColumnReport
extends AbstractAtsAction {
    private XResultData rd;
    private final WorldComposite worldComposite;

    public WorldViewColumnReport(WorldComposite worldComposite) {
        this.worldComposite = worldComposite;
        this.setText("Generate World View Column Report");
        this.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.WORK_PACKAGE));
    }

    @Override
    public void runWithException() {
        this.rd = new XResultData();
        this.rd.log(this.getText());
        try {
            WorldXViewerFactory factory = (WorldXViewerFactory)this.worldComposite.getWorldXViewer().getXViewerFactory();
            IXViewerCustomizations customizations = factory.getXViewerCustomizations();
            List custDatas = customizations.getSavedCustDatas();
            for (CustomizeData cust : custDatas) {
                this.rd.logf("\n\nCust Data [%s] Namespace [%s]\n", new Object[]{cust.getName(), cust.getNameSpace()});
                ColumnData colData = cust.getColumnData();
                for (XViewerColumn xCol : colData.getColumns()) {
                    XViewerColumn column = factory.getDefaultXViewerColumn(xCol.getId());
                    this.rd.logf("--- ColId [%s]\n", new Object[]{xCol.getId()});
                    if (column != null) continue;
                    this.rd.errorf("------ Invalid ColId [%s]\n", new Object[]{xCol.getId()});
                }
            }
        }
        catch (Exception ex) {
            this.rd.error(Lib.exceptionToString((Exception)ex));
        }
        XResultDataUI.report((XResultData)this.rd, (String)this.getText(), (Manipulations[])new Manipulations[]{Manipulations.ERROR_WARNING_HEADER, Manipulations.ALL});
    }
}

