/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditor;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.Shell;

public class OpenOrphanedActionsAndTeamWorkflows
extends Action {
    public OpenOrphanedActionsAndTeamWorkflows() {
        this("Open Orphaned Actions / Team Workflows");
    }

    public OpenOrphanedActionsAndTeamWorkflows(String name) {
        super(name);
        this.setToolTipText(this.getText());
    }

    public void run() {
        if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getText(), (String)this.getText())) {
            AbstractOperation operation = new AbstractOperation(this.getText(), "org.eclipse.osee.ats.ide"){

                protected void doWork(IProgressMonitor monitor) throws Exception {
                    List ids = ArtifactQuery.createQueryBuilder((BranchId)AtsApiService.get().getAtsBranch()).andIsOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action}).andNotExists(AtsRelationTypes.ActionToWorkflow_Action).getIds();
                    if (ids.isEmpty()) {
                        AWorkbench.popup((String)"No Orphaned Action(s) Found");
                    } else {
                        List artifacts = ArtifactQuery.getArtifactListFrom((Collection)ids, (BranchId)AtsApiService.get().getAtsBranch());
                        MassArtifactEditor.editArtifacts((String)"Orphaned Action(s)", (Collection)artifacts, (XNavigateComposite.TableLoadOption[])new XNavigateComposite.TableLoadOption[]{XNavigateComposite.TableLoadOption.None});
                    }
                    List ids2 = ArtifactQuery.createQueryBuilder((BranchId)AtsApiService.get().getAtsBranch()).andIsOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow}).andNotExists(AtsRelationTypes.ActionToWorkflow_TeamWorkflow).getIds();
                    if (ids2.isEmpty()) {
                        AWorkbench.popup((String)"No Orphaned Workflow(s) Found");
                    } else {
                        List artifacts = ArtifactQuery.getArtifactListFrom((Collection)ids2, (BranchId)AtsApiService.get().getAtsBranch());
                        MassArtifactEditor.editArtifacts((String)"Orphaned Team Workflows", (Collection)artifacts, (XNavigateComposite.TableLoadOption[])new XNavigateComposite.TableLoadOption[]{XNavigateComposite.TableLoadOption.None});
                    }
                }
            };
            Operations.executeAsJob((IOperation)operation, (boolean)true);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.ACTION);
    }
}

