/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.conflict.ConflictManagerExternal;

public final class PortPairsOperation
extends AbstractOperation {
    private final List<Pair<String, String>> portPairs;
    private final boolean useAtsID;

    public PortPairsOperation(OperationLogger logger, String portPairs, boolean useAtsID) {
        this(logger, new ArrayList<Pair<String, String>>(), useAtsID);
        String[] stringArray = portPairs.split("[\n\r]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] pairLine = pair.split("[\\s,]+");
            if (pairLine.length != 2) {
                throw new OseeArgumentException("Invalid porting pairs", new Object[0]);
            }
            this.portPairs.add((Pair<String, String>)new Pair((Object)pairLine[0], (Object)pairLine[1]));
            ++n2;
        }
    }

    public PortPairsOperation(OperationLogger logger, List<Pair<String, String>> portPairs, boolean useAtsID) {
        super("Port Pair(s)", "org.eclipse.osee.ats.ide", logger);
        this.portPairs = portPairs;
        this.useAtsID = useAtsID;
    }

    protected void doWork(IProgressMonitor monitor) {
        if (this.portPairs.isEmpty()) {
            throw new OseeArgumentException("Must specify at least one pair.", new Object[0]);
        }
        this.logf("Porting %d pairs of workflows.", new Object[]{this.portPairs.size()});
        double pairPercentage = 100.0 / (double)this.portPairs.size();
        for (Pair<String, String> pair : this.portPairs) {
            this.portPair(pair);
            monitor.worked(this.calculateWork(pairPercentage));
        }
    }

    private void portPair(Pair<String, String> pair) {
        TeamWorkFlowArtifact destinationWorkflow;
        TeamWorkFlowArtifact sourceWorkflow;
        if (this.useAtsID) {
            sourceWorkflow = this.getWorkflowFromAtsID((String)pair.getFirst());
            destinationWorkflow = this.getWorkflowFromAtsID((String)pair.getSecond());
        } else {
            sourceWorkflow = this.getWorkflowFromRpcr((String)pair.getFirst());
            destinationWorkflow = this.getWorkflowFromRpcr((String)pair.getSecond());
        }
        this.doPortWork(sourceWorkflow, destinationWorkflow);
    }

    private TeamWorkFlowArtifact getWorkflowFromRpcr(String workflowId) {
        ArtifactTypeToken LbaReqTeamWorkflow = ArtifactTypeToken.valueOf((long)0xBA000000000BL, (String)"Lba Req Team Workflow", (ArtifactTypeToken[])new ArtifactTypeToken[0]);
        return (TeamWorkFlowArtifact)ArtifactQuery.getArtifactFromTypeAndAttribute((ArtifactTypeId)LbaReqTeamWorkflow, (AttributeTypeId)AtsAttributeTypes.LegacyPcrId, (String)workflowId, (BranchId)AtsApiService.get().getAtsBranch());
    }

    private TeamWorkFlowArtifact getWorkflowFromAtsID(String atsId) {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifactByAtsId(atsId);
    }

    private void doPortWork(TeamWorkFlowArtifact sourceWorkflow, TeamWorkFlowArtifact destinationWorkflow) {
        if (destinationWorkflow.getWorkingBranchForceCacheUpdate() == null) {
            AtsApiService.get().getBranchServiceIde().createWorkingBranch_Create((IAtsTeamWorkflow)destinationWorkflow, true);
        }
        BranchToken destinationBranch = destinationWorkflow.getWorkingBranchForceCacheUpdate();
        BranchToken portBranch = this.getPortBranchFromWorkflow(sourceWorkflow, destinationWorkflow);
        if (portBranch == null) {
            this.logf("Source workflow [%s] not ready for port to Workflow [%s].", new Object[]{sourceWorkflow, destinationWorkflow});
            return;
        }
        try {
            if (BranchManager.getState((BranchId)portBranch).isCommitted()) {
                this.logf("Skipping completed workflow [%s].", new Object[]{destinationWorkflow});
            } else {
                ConflictManagerExternal conflictManager = new ConflictManagerExternal((BranchId)destinationBranch, (BranchId)portBranch);
                TransactionResult transactionResult = BranchManager.commitBranch(null, (ConflictManagerExternal)conflictManager, (boolean)false, (boolean)false);
                if (transactionResult.isFailed()) {
                    throw new OseeCoreException(transactionResult.toString(), new Object[0]);
                }
                this.logf("Commit complete for workflow [%s].", new Object[]{destinationWorkflow});
            }
        }
        catch (OseeCoreException oseeCoreException) {
            this.logf("Resolve conflicts for workflow [%s].", new Object[]{destinationWorkflow});
        }
    }

    private BranchToken getPortBranchFromWorkflow(TeamWorkFlowArtifact sourceWorkflow, TeamWorkFlowArtifact destinationWorkflow) {
        Collection branches;
        if (!sourceWorkflow.isRelated(AtsRelationTypes.Port_To, (ArtifactId)destinationWorkflow)) {
            sourceWorkflow.addRelation(AtsRelationTypes.Port_To, destinationWorkflow);
            sourceWorkflow.persist("create port relation");
        }
        if ((branches = BranchManager.getBranchesByName((String)String.format("Porting [%s] branch", sourceWorkflow.getAtsId()))).isEmpty()) {
            TransactionToken transRecord = AtsApiService.get().getBranchService().getEarliestTransactionId((IAtsTeamWorkflow)sourceWorkflow);
            if (transRecord == null) {
                return null;
            }
            return BranchManager.createWorkingBranchFromTx((TransactionToken)transRecord, (String)String.format("Porting [%s] branch", sourceWorkflow.getAtsId()), null);
        }
        return (BranchToken)branches.iterator().next();
    }
}

