/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public final class FontManager {
    public static Map<String, Font> fontMap = new HashMap<String, Font>();
    private static Color LIGHT_RED;
    private static Color DARK_CYAN;
    private static Color DARK_GREEN;
    private static Color DARK_YELLOW;
    private static Color DARK_BLUE;

    private FontManager() {
    }

    public static Font getDefaultLabelFont() {
        return FontManager.getFont("arial", 12, 1);
    }

    public static Font getCourierNew8() {
        return FontManager.getFont("Courier New", 8, 0);
    }

    public static Font getCourierNew12Bold() {
        return FontManager.getFont("Courier New", 12, 1);
    }

    public static Font getCourierNew12() {
        return FontManager.getFont("Courier New", 12, 0);
    }

    public static Font getFont(String fontName, int size, int swtType) {
        String hashKey = String.valueOf(fontName) + "-" + size + "-" + swtType;
        if (!fontMap.containsKey(hashKey)) {
            Font baseFont = JFaceResources.getDefaultFont();
            FontData[] fontDatas = baseFont.getFontData();
            FontData fontData = fontDatas.length > 0 ? fontDatas[0] : new FontData(fontName, size, swtType);
            fontMap.put(hashKey, new Font(baseFont.getDevice(), fontData.getName(), fontData.getHeight(), 1));
        }
        return fontMap.get(hashKey);
    }

    public static Color getLightRed() {
        if (LIGHT_RED == null) {
            LIGHT_RED = Displays.getColor(255, 108, 113);
        }
        return LIGHT_RED;
    }

    public static Color getDarkCyan() {
        if (DARK_CYAN == null) {
            DARK_CYAN = Displays.getSystemColor(14);
        }
        return DARK_CYAN;
    }

    public static Color getDarkBlue() {
        if (DARK_BLUE == null) {
            DARK_BLUE = Displays.getSystemColor(10);
        }
        return DARK_BLUE;
    }

    public static Color getDarkGreen() {
        if (DARK_GREEN == null) {
            DARK_GREEN = Displays.getSystemColor(6);
        }
        return DARK_GREEN;
    }

    public static Color getDarkYellow() {
        if (DARK_YELLOW == null) {
            DARK_YELLOW = Displays.getSystemColor(8);
        }
        return DARK_YELLOW;
    }
}

