/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.register;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.vim.register.RegisterContent;

public class TextBlockRegisterContent
implements RegisterContent {
    private final List<String> payload = new ArrayList<String>();
    private final int visualWidth;
    private String newLine;

    public TextBlockRegisterContent(int visualWidth, String newLine) {
        this.visualWidth = visualWidth;
        this.newLine = newLine;
    }

    @Override
    public ContentType getPayloadType() {
        return ContentType.TEXT_RECTANGLE;
    }

    public void appendLine(String line) {
        this.payload.add(line);
    }

    @Override
    public String getText() {
        return StringUtils.join(this.newLine, this.payload).concat(this.newLine);
    }

    public int getVisualWidth() {
        return this.visualWidth;
    }

    public int getNumLines() {
        return this.payload.size();
    }

    public String getLine(int lineNo) {
        return this.payload.get(lineNo);
    }
}

