/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.register;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.utils.SelectionArea;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.SubstitutionOperation;
import net.sourceforge.vrapper.vim.commands.motions.FindCharMotion;
import net.sourceforge.vrapper.vim.commands.motions.NavigatingMotion;
import net.sourceforge.vrapper.vim.register.AppendRegister;
import net.sourceforge.vrapper.vim.register.NamedRegister;
import net.sourceforge.vrapper.vim.register.ReadOnlyRegister;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.RegisterManager;
import net.sourceforge.vrapper.vim.register.SimpleRegister;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;

public class DefaultRegisterManager
implements RegisterManager {
    protected final Map<String, Register> registers = new HashMap<String, Register>();
    protected Register activeRegister;
    protected Register defaultRegister = this.unnamedRegister = new SimpleRegister();
    protected final Register unnamedRegister;
    private final Register lastEditRegister = new SimpleRegister();
    private Search search;
    private Command lastEdit;
    private Command lastInsertion;
    private SubstitutionOperation lastSubstitution;
    private FindCharMotion findCharMotion;
    private NavigatingMotion lastNavigatingMotion;
    private SelectionArea lastActiveSelectionArea;
    private String cwd = "/";
    private String lastCommand;

    public DefaultRegisterManager() {
        this(null);
    }

    public DefaultRegisterManager(Map<String, Register> platformRegisters) {
        this.activeRegister = this.defaultRegister;
        this.registers.put("\"", this.unnamedRegister);
        ReadOnlyRegister lastInsertRegister = new ReadOnlyRegister(){

            @Override
            public RegisterContent getContent() {
                return DefaultRegisterManager.this.lastEditRegister.getContent();
            }
        };
        this.registers.put(".", lastInsertRegister);
        ReadOnlyRegister searchRegister = new ReadOnlyRegister(){

            @Override
            public RegisterContent getContent() {
                if (DefaultRegisterManager.this.search == null) {
                    return RegisterContent.DEFAULT_CONTENT;
                }
                return new StringRegisterContent(ContentType.TEXT, DefaultRegisterManager.this.search.getKeyword());
            }
        };
        this.registers.put("/", searchRegister);
        ReadOnlyRegister blackholeRegister = new ReadOnlyRegister(){

            @Override
            public RegisterContent getContent() {
                return RegisterContent.DEFAULT_CONTENT;
            }

            @Override
            public void setContent(RegisterContent content, boolean copyToUnnamed) {
                DefaultRegisterManager.this.activateDefaultRegister();
            }
        };
        this.registers.put("_", blackholeRegister);
        this.registers.put(":", new ReadOnlyRegister(){

            @Override
            public RegisterContent getContent() {
                return new StringRegisterContent(ContentType.TEXT, DefaultRegisterManager.this.lastCommand);
            }
        });
        if (platformRegisters != null) {
            this.registers.putAll(platformRegisters);
        }
    }

    @Override
    public Set<String> getRegisterNames() {
        return this.registers.keySet();
    }

    @Override
    public Register getRegister(String name) {
        String key = name.toLowerCase();
        if (!this.registers.containsKey(key)) {
            this.registers.put(key, new NamedRegister(this.unnamedRegister));
        }
        Register r = this.registers.get(key);
        if (!name.equals(key)) {
            r = new AppendRegister(r);
        }
        return r;
    }

    @Override
    public Register getDefaultRegister() {
        return this.defaultRegister;
    }

    @Override
    public Register getActiveRegister() {
        return this.activeRegister;
    }

    @Override
    public void setActiveRegister(String name) {
        this.activeRegister = this.getRegister(name);
    }

    @Override
    public void activateDefaultRegister() {
        this.activeRegister = this.defaultRegister;
    }

    @Override
    public void activateLastEditRegister() {
        this.activeRegister = this.lastEditRegister;
    }

    @Override
    public Register getLastEditRegister() {
        return this.lastEditRegister;
    }

    @Override
    public void setLastNamedRegister(Register register) {
        this.registers.put("@", register);
    }

    @Override
    public Search getSearch() {
        return this.search;
    }

    @Override
    public void setSearch(Search search) {
        this.search = search;
    }

    @Override
    public Command getLastEdit() {
        return this.lastEdit;
    }

    @Override
    public void setLastEdit(Command lastEdit) {
        this.lastEdit = lastEdit;
    }

    @Override
    public FindCharMotion getLastFindCharMotion() {
        return this.findCharMotion;
    }

    @Override
    public void setLastFindCharMotion(FindCharMotion motion) {
        this.findCharMotion = motion;
    }

    @Override
    public void setLastNavigatingMotion(NavigatingMotion motion) {
        this.lastNavigatingMotion = motion;
    }

    @Override
    public NavigatingMotion getLastNavigatingMotion() {
        return this.lastNavigatingMotion;
    }

    @Override
    public void setActiveRegister(Register register) {
        this.activeRegister = register;
    }

    @Override
    public boolean isDefaultRegisterActive() {
        return this.activeRegister == this.defaultRegister;
    }

    @Override
    public void setLastActiveSelection(SelectionArea selectionArea) {
        this.lastActiveSelectionArea = selectionArea;
    }

    @Override
    public SelectionArea getLastActiveSelectionArea() {
        return this.lastActiveSelectionArea;
    }

    @Override
    public void setLastInsertion(Command command) {
        this.lastInsertion = command;
    }

    @Override
    public Command getLastInsertion() {
        return this.lastInsertion;
    }

    @Override
    public void setLastSubstitution(SubstitutionOperation operation) {
        this.lastSubstitution = operation;
    }

    @Override
    public SubstitutionOperation getLastSubstitution() {
        return this.lastSubstitution;
    }

    @Override
    public void setLastYank(RegisterContent register) {
        this.getRegister("0").setContent(register);
    }

    @Override
    public void setLastDelete(RegisterContent register) {
        if (!VimUtils.containsNewLine(register.getText())) {
            this.getRegister("-").setContent(register);
        } else {
            int i = 8;
            while (i > 0) {
                String key = "" + i;
                if (this.registers.containsKey(key)) {
                    this.getRegister("" + (i + 1)).setContent(this.getRegister(key).getContent());
                }
                --i;
            }
            this.getRegister("1").setContent(register);
        }
    }

    @Override
    public void setCurrentWorkingDirectory(String newDir) {
        if (newDir.startsWith("/")) {
            this.cwd = newDir;
        } else {
            if (!this.cwd.endsWith("/")) {
                this.cwd = String.valueOf(this.cwd) + "/";
            }
            this.cwd = String.valueOf(this.cwd) + newDir;
        }
        if (this.cwd.contains("..")) {
            String[] pieces = this.cwd.split("/");
            ArrayList<String> dirs = new ArrayList<String>();
            int i = 0;
            while (i < pieces.length) {
                if ("..".equals(pieces[i])) {
                    if (!dirs.isEmpty()) {
                        dirs.remove(dirs.size() - 1);
                    }
                } else {
                    dirs.add(pieces[i]);
                }
                ++i;
            }
            this.cwd = dirs.isEmpty() ? "/" : StringUtils.join("/", dirs);
        }
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return this.cwd;
    }

    @Override
    public void setLastCommand(String macroString) {
        this.lastCommand = macroString;
    }
}

