/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.register;

import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.vim.VimConstants;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;

public class AppendRegister
implements Register {
    private final Register delegate;

    public AppendRegister(Register delegate) {
        this.delegate = delegate;
    }

    @Override
    public RegisterContent getContent() {
        return this.delegate.getContent();
    }

    @Override
    public void setContent(RegisterContent content) {
        this.setContent(content, true);
    }

    @Override
    public void setContent(RegisterContent content, boolean copyToUnnamed) {
        ContentType appendedType;
        String newline = VimConstants.REGISTER_NEWLINE;
        RegisterContent oldContent = this.getContent();
        ContentType oldType = oldContent.getPayloadType();
        ContentType type = oldType == (appendedType = content.getPayloadType()) ? appendedType : (oldType == ContentType.LINES || appendedType == ContentType.LINES ? ContentType.LINES : ContentType.TEXT);
        StringBuilder sb = new StringBuilder();
        sb.append(oldContent.getText());
        if (oldType != ContentType.LINES && type == ContentType.LINES) {
            sb.append(newline);
        }
        sb.append(content.getText());
        if (appendedType != ContentType.LINES && type == ContentType.LINES) {
            sb.append(newline);
        }
        StringRegisterContent newContent = new StringRegisterContent(type, sb.toString());
        this.delegate.setContent(newContent, copyToUnnamed);
    }
}

