/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.utils.SearchOffset;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.modes.AbstractVisualMode;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.modes.commandline.AbstractCommandParser;

public class SearchCommandParser
extends AbstractCommandParser {
    private static final Pattern AFTER_SEARCH_PATTERN = Pattern.compile("(e|b)?\\+?(-?\\d+)?");
    private Command commandToExecute;

    public SearchCommandParser(EditorAdaptor vim, Command commandToExecute) {
        super(vim);
        this.commandToExecute = commandToExecute;
    }

    @Override
    public Command parseAndExecute(String first, String command) {
        Search search = this.parseSearchCommand(first, command);
        this.editor.getRegisterManager().setSearch(search);
        this.editor.setLastSearchResult(null);
        this.editor.getSearchAndReplaceService().removeHighlighting();
        return this.commandToExecute;
    }

    @Override
    protected void handleExit(Command parsedCommand) {
        if (parsedCommand == null) {
            this.editor.changeModeSafely(this.editor.getLastModeName(), AbstractVisualMode.RECALL_SELECTION_HINT);
        } else {
            this.editor.changeModeSafely(this.editor.getLastModeName(), new ExecuteCommandHint.OnEnter(parsedCommand), AbstractVisualMode.RECALL_SELECTION_HINT);
        }
    }

    public static Search createSearch(EditorAdaptor editor, String keyword, boolean backward, SearchOffset offset) {
        return SearchCommandParser.createSearch(editor, keyword, backward, offset, editor.getConfiguration().get(Options.SEARCH_REGEX));
    }

    public static Search createSearch(EditorAdaptor editor, String keyword, boolean backward, SearchOffset offset, boolean useRegExp) {
        int index;
        boolean caseSensitive = editor.getConfiguration().get(Options.IGNORE_CASE) == false || editor.getConfiguration().get(Options.SMART_CASE) != false && StringUtils.containsUppercase(keyword);
        boolean searchInSelection = false;
        if (keyword.contains("\\c")) {
            index = keyword.indexOf("\\c");
            caseSensitive = false;
            keyword = String.valueOf(keyword.substring(0, index)) + keyword.substring(index + 2);
        }
        if (keyword.contains("\\C")) {
            index = keyword.indexOf("\\C");
            caseSensitive = true;
            keyword = String.valueOf(keyword.substring(0, index)) + keyword.substring(index + 2);
        }
        if (keyword.contains("\\%V")) {
            index = keyword.indexOf("\\%V");
            searchInSelection = true;
            keyword = String.valueOf(keyword.substring(0, index)) + keyword.substring(index + 3);
        }
        if (offset == null) {
            offset = SearchOffset.NONE;
        }
        return new Search(keyword, backward, caseSensitive, offset, useRegExp, searchInSelection);
    }

    private Search parseSearchCommand(String first, String command) {
        boolean useLastKeyword;
        boolean backward = first.equals("?");
        String[] searchFields = this.splitSearchCommand(first, command);
        String keyword = searchFields[0];
        Search lastSearch = this.editor.getRegisterManager().getSearch();
        boolean bl = useLastKeyword = keyword.length() == 0 && lastSearch != null;
        if (useLastKeyword) {
            keyword = lastSearch.getKeyword();
        }
        SearchOffset searchOffset = searchFields.length > 1 ? this.createSearchOffset(searchFields[1]) : (useLastKeyword ? lastSearch.getSearchOffset() : SearchOffset.NONE);
        Search search = SearchCommandParser.createSearch(this.editor, keyword, backward, searchOffset);
        return search;
    }

    public String getKeyWord() {
        String first = this.commandLine.getPrompt();
        String command = this.commandLine.getContents();
        return this.splitSearchCommand(first, command)[0];
    }

    private String[] splitSearchCommand(String first, String command) {
        if (command.length() == 0) {
            return new String[]{""};
        }
        boolean delimNeedsEscaping = first.equals("?");
        String delimiter = delimNeedsEscaping ? String.valueOf('\\') + first : first;
        String[] fields = command.split("(?<!\\\\)" + delimiter, -1);
        if (fields.length == 0) {
            fields = new String[]{""};
        }
        fields[0] = fields[0].replace("\\" + first, first);
        return fields;
    }

    private SearchOffset createSearchOffset(String afterSearch) {
        if (VimUtils.isBlank(afterSearch)) {
            return SearchOffset.NONE;
        }
        Matcher m = AFTER_SEARCH_PATTERN.matcher(afterSearch);
        if (!m.find()) {
            return SearchOffset.NONE;
        }
        String group = m.group(2);
        int offset = VimUtils.isBlank(group) ? 0 : Integer.parseInt(group);
        group = m.group(1);
        if (VimUtils.isBlank(group)) {
            return new SearchOffset.Line(offset);
        }
        boolean jumpToEnd = group.equals("e");
        if (jumpToEnd) {
            return new SearchOffset.End(offset);
        }
        if (offset != 0) {
            return new SearchOffset.Begin(offset);
        }
        return SearchOffset.NONE;
    }
}

