/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.platform.CommandLineUI;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.PasteRegisterCommand;
import net.sourceforge.vrapper.vim.modes.AbstractMode;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.modes.InsertMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;

public class PasteRegisterMode
extends AbstractMode {
    public static final String DISPLAY_NAME = "PASTE REGISTER";
    public static final String NAME = "paste register";
    protected static final KeyStroke KEY_RETURN = ConstructorWrappers.key(SpecialKey.RETURN);
    protected static final KeyStroke KEY_ESCAPE = ConstructorWrappers.key(SpecialKey.ESC);
    protected static final KeyStroke KEY_BACKSP = ConstructorWrappers.key(SpecialKey.BACKSPACE);
    protected CommandLineUI commandLine;
    protected ExecuteCommandHint.OnLeave onLeaveCommandHint;

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public PasteRegisterMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public String resolveKeyMap(KeyStroke stroke) {
        return null;
    }

    @Override
    public void enterMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        super.enterMode(hints);
        this.onLeaveCommandHint = VimUtils.findModeHint(ExecuteCommandHint.OnLeave.class, hints);
        this.commandLine = this.editorAdaptor.getCommandLine();
        this.commandLine.setPrompt("\"");
        this.commandLine.open();
    }

    @Override
    public void leaveMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        super.leaveMode(hints);
        this.commandLine.close();
    }

    @Override
    public boolean handleKey(KeyStroke e) {
        if (e.equals(KEY_RETURN) || e.equals(KEY_ESCAPE) || e.equals(KEY_BACKSP)) {
            this.changeBackToInsertMode();
            return true;
        }
        PasteRegisterCommand command = new PasteRegisterCommand(Character.toString(e.getCharacter()));
        try {
            command.execute(this.editorAdaptor);
        }
        catch (CommandExecutionException err) {
            this.editorAdaptor.getUserInterfaceService().setErrorMessage(err.getMessage());
        }
        this.changeBackToInsertMode();
        return true;
    }

    protected void changeBackToInsertMode() {
        if (this.onLeaveCommandHint != null) {
            this.editorAdaptor.changeModeSafely("insert mode", InsertMode.RESUME_ON_MODE_ENTER, this.onLeaveCommandHint);
        } else {
            this.editorAdaptor.changeModeSafely("insert mode", InsertMode.RESUME_ON_MODE_ENTER);
        }
    }
}

