/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.platform.CommandLineUI;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.modes.AbstractMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;

public class MessageMode
extends AbstractMode {
    public static final String NAME = "message or more mode";
    private CommandLineUI commandLine;
    public static final ModeSwitchHint CLIP_LINES_HINT = new ModeSwitchHint(){};
    protected static final KeyStroke KEY_SPACE = ConstructorWrappers.key(' ');
    protected static final KeyStroke KEY_RETURN = ConstructorWrappers.key(SpecialKey.RETURN);
    protected static final KeyStroke KEY_ESCAPE = ConstructorWrappers.key(SpecialKey.ESC);
    protected static final KeyStroke KEY_Q = ConstructorWrappers.key('q');

    public MessageMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return "MESSAGE";
    }

    @Override
    public String resolveKeyMap(KeyStroke stroke) {
        return null;
    }

    @Override
    public void enterMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        super.enterMode(hints);
        String messages = null;
        boolean clipLines = false;
        ModeSwitchHint[] modeSwitchHintArray = hints;
        int n = hints.length;
        int n2 = 0;
        while (n2 < n) {
            ModeSwitchHint hint = modeSwitchHintArray[n2];
            if (hint instanceof MessagesHint) {
                messages = ((MessagesHint)hint).getMessages();
            }
            if (hint == CLIP_LINES_HINT) {
                clipLines = true;
            }
            ++n2;
        }
        if (messages == null) {
            throw new CommandExecutionException("No messages hint set!");
        }
        this.commandLine = this.editorAdaptor.getCommandLine();
        this.commandLine.setPrompt("");
        this.commandLine.resetContents(messages);
        if (clipLines) {
            this.commandLine.setMode(CommandLineUI.CommandLineMode.MESSAGE_CLIPPED);
        } else {
            this.commandLine.setMode(CommandLineUI.CommandLineMode.MESSAGE);
        }
        this.commandLine.open();
        this.updateMorePrompt();
    }

    @Override
    public void leaveMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        super.leaveMode(hints);
        this.commandLine.close();
    }

    @Override
    public boolean handleKey(KeyStroke s) {
        if (s.equals(KEY_ESCAPE) || s.equals(KEY_Q) || s.equals(KEY_RETURN) && this.commandLine.isLastLineShown()) {
            this.editorAdaptor.getUserInterfaceService().setInfoMessage("");
            this.editorAdaptor.changeModeSafely("normal mode", new ModeSwitchHint[0]);
            return true;
        }
        if (s.equals(KEY_RETURN)) {
            this.commandLine.scrollDown(false);
        } else if (s.equals(KEY_SPACE)) {
            this.commandLine.scrollDown(true);
        }
        this.updateMorePrompt();
        return true;
    }

    public void updateMorePrompt() {
        if (this.commandLine.isLastLineShown()) {
            this.editorAdaptor.getUserInterfaceService().setInfoMessage("Press RETURN or q to close.");
        } else {
            this.editorAdaptor.getUserInterfaceService().setInfoMessage("More -- press RETURN or space to scroll, q to quit");
        }
    }

    public static class MessagesHint
    implements ModeSwitchHint {
        private String messages;

        public MessagesHint(String messages) {
            this.messages = messages;
        }

        public String getMessages() {
            return this.messages;
        }
    }
}

